//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLPageElementSpec extends HTMLGUIElementSpec implements IGUIElementSpec {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private HTMLDocumentSpec page;
    
    /** */
    private String tagName;
    
    /** */
    private String htmlId;
    
    /** */
    private int index;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param type
     * @param index
     * @param id
     */
    public HTMLPageElementSpec(HTMLDocumentSpec page, String tagName, String htmlId, int index) {
        super(tagName);
        
        if (page == null) {
            throw new IllegalArgumentException("page must not be null");
        }
        else if (tagName == null) {
            throw new IllegalArgumentException("tag must not be null");
        }
        else if ((htmlId == null) && (index < 0)) {
            throw new IllegalArgumentException
                ("either id must not be null or the index must be greater or equal to 0");
        }
        
        this.page = page;
        this.tagName = tagName;
        this.htmlId = htmlId;
        this.index = index;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getSimilarity(IGUIElementSpec)
     */
    @Override
    public boolean getSimilarity(IGUIElementSpec other) {
        if (other instanceof HTMLPageElementSpec) {
            HTMLPageElementSpec otherSpec = (HTMLPageElementSpec) other;
            
            if (!super.getSimilarity(otherSpec)) {
                return false;
            }
            /*else if (!page.getSimilarity(otherSpec.page)) {
                return false;
            }*/
            else if (!tagName.equals(otherSpec.tagName)) {
                return false;
            }
            
            if (htmlId != null) {
                return htmlId.equals(otherSpec.htmlId);
            }
            else if (index >= 0) {
                return index == otherSpec.index;
            }
        }
        
        return false;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String str = getTagName();
        
        if ((getHtmlId() != null) && (!"".equals(getHtmlId()))) {
            str += "(id=\"" + getHtmlId() + "\")";
        }
        else {
            str += "[" + getIndex() + "]";
        }
        
        return str;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    HTMLDocumentSpec getPage() {
        return page;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getTagName() {
        return tagName;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getHtmlId() {
        return htmlId;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    int getIndex() {
        return index;
    }

}
