//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules;

import java.util.List;

import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.rules.metrics.NoLetterOrDigitRatioMetric;
import de.ugoe.cs.autoquest.usability.rules.metrics.TextInputEntryRepetitionsMetric;
import de.ugoe.cs.autoquest.usability.rules.metrics.TextInputRatioMetric;

/**
 * <p>
 * A ruleset containing usability metrics, which might be indicators for potential usability
 * problems.
 * </p>
 * 
 * @author Alexander Deicke
 */
public class UsabilityMetricsRuleset implements UsabilityRuleset {

    private List<UsabilityRule> metrics;

    /**
     * <p>
     * Constructor. Creates new {@code UsabilityMetricsRuleset} for a given task model.
     * </p>
     * 
     */
    private UsabilityMetricsRuleset(ITaskModel taskModel) {
        this.metrics = Lists.newArrayList();
        metrics.add(new NoLetterOrDigitRatioMetric(taskModel));
        metrics.add(new TextInputEntryRepetitionsMetric(taskModel));
        metrics.add(new TextInputRatioMetric(taskModel));
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.usability.UsabilityRuleset#evaluationRules()
     */
    @Override
    public List<UsabilityRule> evaluationRules() {
        return this.metrics;
    }

}
