//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLDocumentSpec extends HTMLGUIElementSpec implements IGUIElementSpec {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private HTMLServerSpec server;
    
    /** */
    private String path;
    
    /** */
    private String query;
    
    /** */
    private String title;
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param server
     * @param pagePath
     * @param pageTitle
     */
    public HTMLDocumentSpec(HTMLServerSpec server, String path, String query, String title) {
        super("document");
        
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        else if (path == null) {
            throw new IllegalArgumentException("pagePath must not be null");
        }
        
        this.server = server;
        this.path = path;
        this.query = query;
        this.title = title;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getSimilarity(IGUIElementSpec)
     */
    @Override
    public boolean getSimilarity(IGUIElementSpec other) {
        if (other instanceof HTMLDocumentSpec) {
            HTMLDocumentSpec otherSpec = (HTMLDocumentSpec) other;
            
            if (!super.getSimilarity(otherSpec)) {
                return false;
            }
            else if (!server.getSimilarity(otherSpec.server)) {
                return false;
            }
            else if (!path.equals(otherSpec.path)) {
                return false;
            }
            else if (query != null ? !query.equals(otherSpec.query) : otherSpec.query != null) {
                return false;
            }
            else {
                return (title != null ? title.equals(otherSpec.title) : otherSpec.title == null);
            }
        }
        
        return false;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "Document(" + getPath() + ", \"" + getTitle() + "\")";
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    public HTMLServerSpec getServer() {
        return server;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getPath() {
        return path;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getQuery() {
        return query;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getTitle() {
        return title;
    }

}
