/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.Analyze;
import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.type.NullType;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBadCast2
implements Detector {
    private final BugReporter bugReporter;
    private final Set<String> concreteCollectionClasses = new HashSet<String>();
    private final Set<String> abstractCollectionClasses = new HashSet<String>();
    private final Set<String> veryAbstractCollectionClasses = new HashSet<String>();
    private static final boolean DEBUG = SystemProperties.getBoolean("bc.debug");

    public FindBadCast2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.veryAbstractCollectionClasses.add("java.util.Collection");
        this.veryAbstractCollectionClasses.add("java.util.Iterable");
        this.abstractCollectionClasses.add("java.util.Collection");
        this.abstractCollectionClasses.add("java.util.List");
        this.abstractCollectionClasses.add("java.util.Set");
        this.abstractCollectionClasses.add("java.util.SortedSet");
        this.abstractCollectionClasses.add("java.util.SortedMap");
        this.abstractCollectionClasses.add("java.util.Map");
        this.concreteCollectionClasses.add("java.util.LinkedHashMap");
        this.concreteCollectionClasses.add("java.util.LinkedHashSet");
        this.concreteCollectionClasses.add("java.util.HashMap");
        this.concreteCollectionClasses.add("java.util.HashSet");
        this.concreteCollectionClasses.add("java.util.TreeMap");
        this.concreteCollectionClasses.add("java.util.TreeSet");
        this.concreteCollectionClasses.add("java.util.ArrayList");
        this.concreteCollectionClasses.add("java.util.LinkedList");
        this.concreteCollectionClasses.add("java.util.Hashtable");
        this.concreteCollectionClasses.add("java.util.Vector");
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : methodList = javaClass.getMethods()) {
            String msg;
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (MethodUnprofitableException e) {
            }
            catch (CFGBuilderException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
            catch (DataflowAnalysisException e) {
                msg = "Detector " + this.getClass().getName() + " caught exception while analyzing " + javaClass.getClassName() + "." + method.getName() + " : " + method.getSignature();
                this.bugReporter.logError(msg, e);
            }
        }
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(192) || bytecodeSet.get(193));
    }

    private boolean isSynthetic(Method m) {
        Attribute[] attrs;
        if (m.isSynthetic()) {
            return true;
        }
        for (Attribute attr : attrs = m.getAttributes()) {
            if (!(attr instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    private Set<ValueNumber> getParameterValueNumbers(ClassContext classContext, Method method, CFG cfg) throws DataflowAnalysisException, CFGBuilderException {
        int firstParam;
        ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
        ValueNumberFrame vnaFrameAtEntry = (ValueNumberFrame)vnaDataflow.getStartFact(cfg.getEntry());
        HashSet<ValueNumber> paramValueNumberSet = new HashSet<ValueNumber>();
        for (int i = firstParam = method.isStatic() ? 0 : 1; i < vnaFrameAtEntry.getNumLocals(); ++i) {
            paramValueNumberSet.add((ValueNumber)vnaFrameAtEntry.getValue(i));
        }
        return paramValueNumberSet;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        if (this.isSynthetic(method) || !this.prescreen(classContext, method)) {
            return;
        }
        BugAccumulator accumulator = new BugAccumulator(this.bugReporter);
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        IsNullValueDataflow isNullDataflow = classContext.getIsNullValueDataflow(method);
        Set<ValueNumber> paramValueNumberSet = null;
        Dataflow vnaDataflow = null;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        String methodName = methodGen.getClassName() + "." + methodGen.getName();
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        if (DEBUG) {
            System.out.println("Checking " + methodName);
        }
        HashSet<SourceLineAnnotation> haveInstanceOf = new HashSet<SourceLineAnnotation>();
        HashSet<SourceLineAnnotation> haveCast = new HashSet<SourceLineAnnotation>();
        HashSet<SourceLineAnnotation> haveMultipleInstanceOf = new HashSet<SourceLineAnnotation>();
        HashSet<SourceLineAnnotation> haveMultipleCast = new HashSet<SourceLineAnnotation>();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof CHECKCAST) && !(ins instanceof INSTANCEOF)) continue;
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
            if (ins instanceof CHECKCAST) {
                if (haveCast.add(sourceLineAnnotation)) continue;
                haveMultipleCast.add(sourceLineAnnotation);
                continue;
            }
            if (haveInstanceOf.add(sourceLineAnnotation)) continue;
            haveMultipleInstanceOf.add(sourceLineAnnotation);
        }
        BitSet linesMentionedMultipleTimes = classContext.linesMentionedMultipleTimes(method);
        LineNumberTable lineNumberTable = methodGen.getLineNumberTable(methodGen.getConstantPool());
        Iterator<Location> i2 = cfg.locationIterator();
        while (i2.hasNext()) {
            Type operandType;
            TypeFrame frame;
            IsNullValueFrame nullFrame;
            int line;
            boolean split;
            Location location = i2.next();
            InstructionHandle handle = location.getHandle();
            int pc = handle.getPosition();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof CHECKCAST) && !(ins instanceof INSTANCEOF)) continue;
            boolean isCast = ins instanceof CHECKCAST;
            String kind = isCast ? "checkedCast" : "instanceof";
            int occurrences = cfg.getLocationsContainingInstructionWithOffset(pc).size();
            boolean bl = split = occurrences > 1;
            if (lineNumberTable != null && (line = lineNumberTable.getSourceLine(handle.getPosition())) > 0 && linesMentionedMultipleTimes.get(line)) {
                split = true;
            }
            if (!(nullFrame = (IsNullValueFrame)isNullDataflow.getFactAtLocation(location)).isValid()) continue;
            IsNullValue operandNullness = (IsNullValue)nullFrame.getTopValue();
            if (DEBUG) {
                System.out.println(kind + " at pc: " + pc + " in " + methodName);
                System.out.println(" occurrences: " + occurrences);
                System.out.println("XXX: " + operandNullness);
            }
            if (split && !isCast || !(frame = (TypeFrame)typeDataflow.getFactAtLocation(location)).isValid() || (operandType = (Type)frame.getTopValue()).equals(TopType.instance())) continue;
            boolean operandTypeIsExact = frame.isExact(frame.getStackLocation(0));
            Type castType = ((TypedInstruction)((Object)ins)).getType(cpg);
            if (!(castType instanceof ReferenceType)) continue;
            String castSig = castType.getSignature();
            if (operandType.equals(NullType.instance()) || operandNullness.isDefinitelyNull()) {
                SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
                assert (castSig.length() > 1);
                if (isCast) continue;
                accumulator.accumulateBug(new BugInstance(this, "NP_NULL_INSTANCEOF", split ? 3 : 2).addClassAndMethod(methodGen, sourceFile).addType(castSig), sourceLineAnnotation);
                continue;
            }
            if (!(operandType instanceof ReferenceType)) continue;
            ReferenceType refType = (ReferenceType)operandType;
            boolean impliesByGenerics = ((TypeAnalysis)typeDataflow.getAnalysis()).isImpliedByGenericTypes(refType);
            if (impliesByGenerics && !isCast || isCast && refType.equals(castType)) continue;
            String refSig = refType.getSignature();
            String castSig2 = castSig;
            String refSig2 = refSig;
            while (castSig2.charAt(0) == '[' && refSig2.charAt(0) == '[') {
                castSig2 = castSig2.substring(1);
                refSig2 = refSig2.substring(1);
            }
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(classContext, methodGen, sourceFile, handle);
            if (refSig2.charAt(0) != 'L' || castSig2.charAt(0) != 'L') {
                if (castSig2.charAt(0) == '[' && (refSig2.equals("Ljava/io/Serializable;") || refSig2.equals("Ljava/lang/Object;") || refSig2.equals("Ljava/lang/Cloneable;")) || refSig2.charAt(0) == '[' && (castSig2.equals("Ljava/io/Serializable;") || castSig2.equals("Ljava/lang/Object;") || castSig2.equals("Ljava/lang/Cloneable;"))) continue;
                int priority = 1;
                if (split && (castSig2.endsWith("Error;") || castSig2.endsWith("Exception;"))) {
                    priority = 3;
                }
                this.bugReporter.reportBug(new BugInstance(this, isCast ? "BC_IMPOSSIBLE_CAST" : "BC_IMPOSSIBLE_INSTANCEOF", priority).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(refType, castType).addSourceLine(sourceLineAnnotation));
                continue;
            }
            if (!operandTypeIsExact && refSig2.equals("Ljava/lang/Object;") || !isCast && haveMultipleInstanceOf.contains(sourceLineAnnotation)) continue;
            String castName = castSig2.substring(1, castSig2.length() - 1).replace('/', '.');
            String refName = refSig2.substring(1, refSig2.length() - 1).replace('/', '.');
            if (vnaDataflow == null) {
                vnaDataflow = classContext.getValueNumberDataflow(method);
            }
            ValueNumberFrame vFrame = (ValueNumberFrame)vnaDataflow.getFactAtLocation(location);
            if (paramValueNumberSet == null) {
                paramValueNumberSet = this.getParameterValueNumbers(classContext, method, cfg);
            }
            ValueNumber valueNumber = (ValueNumber)vFrame.getTopValue();
            boolean isParameter = paramValueNumberSet.contains(valueNumber);
            BugAnnotation variable = ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, valueNumber, vFrame, "VALUE_OF");
            BugAnnotation source = BugInstance.getSourceForTopStackValue(classContext, method, location);
            try {
                boolean completeInformation;
                boolean castToAbstractCollection;
                JavaClass castJavaClass = Repository.lookupClass(castName);
                JavaClass refJavaClass = Repository.lookupClass(refName);
                boolean upcast = Repository.instanceOf(refJavaClass, castJavaClass);
                if (upcast || refType.equals(castType)) {
                    if (isCast) continue;
                    accumulator.accumulateBug(new BugInstance(this, "BC_VACUOUS_INSTANCEOF", 2).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(refType, castType), sourceLineAnnotation);
                    continue;
                }
                boolean downcast = Repository.instanceOf(castJavaClass, refJavaClass);
                if (!operandTypeIsExact && refName.equals("java.lang.Object")) continue;
                double rank = 0.0;
                boolean castToConcreteCollection = this.concreteCollectionClasses.contains(castName) && this.abstractCollectionClasses.contains(refName);
                boolean bl2 = castToAbstractCollection = this.abstractCollectionClasses.contains(castName) && this.veryAbstractCollectionClasses.contains(refName);
                if (!operandTypeIsExact) {
                    rank = Analyze.deepInstanceOf(refJavaClass, castJavaClass);
                    if (castToConcreteCollection && rank > 0.6) {
                        rank = (rank + 0.6) / 2.0;
                    } else if (castToAbstractCollection && rank > 0.3) {
                        rank = (rank + 0.3) / 2.0;
                    }
                }
                boolean bl3 = completeInformation = !castJavaClass.isInterface() && !refJavaClass.isInterface() || refJavaClass.isFinal() || castJavaClass.isFinal();
                if (DEBUG) {
                    System.out.println(" In " + classContext.getFullyQualifiedMethodName(method));
                    System.out.println("At pc: " + handle.getPosition());
                    System.out.println("cast from " + refName + " to " + castName);
                    System.out.println("  is downcast: " + downcast);
                    System.out.println("  operand type is exact: " + operandTypeIsExact);
                    System.out.println("  complete information: " + completeInformation);
                    System.out.println("  isParameter: " + valueNumber);
                    System.out.println("  score: " + rank);
                    if (handle.getPrev() == null) {
                        System.out.println("  prev is null");
                    } else {
                        System.out.println("  prev is " + handle.getPrev());
                    }
                }
                if (!downcast && completeInformation || operandTypeIsExact) {
                    String bugPattern = isCast ? (downcast && operandTypeIsExact ? (refSig.equals("[Ljava/lang/Object;") && source instanceof MethodAnnotation && ((MethodAnnotation)source).getMethodName().equals("toArray") && ((MethodAnnotation)source).getMethodSignature().equals("()[Ljava/lang/Object;") ? "BC_IMPOSSIBLE_DOWNCAST_OF_TOARRAY" : "BC_IMPOSSIBLE_DOWNCAST") : "BC_IMPOSSIBLE_CAST") : "BC_IMPOSSIBLE_INSTANCEOF";
                    this.bugReporter.reportBug(new BugInstance(this, bugPattern, isCast ? 1 : 2).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(refType, castType).addOptionalUniqueAnnotations(variable, source).addSourceLine(sourceLineAnnotation));
                    continue;
                }
                if (!isCast || !(rank < 0.9) || !(variable instanceof LocalVariableAnnotation) || valueNumber.hasFlag(2) || valueNumber.hasFlag(1)) continue;
                int priority = 2;
                priority = rank > 0.75 ? (priority += 2) : (rank > 0.5 ? ++priority : (rank > 0.25 ? (priority += 0) : --priority));
                if (DEBUG) {
                    System.out.println(" priority a: " + priority);
                }
                if (methodGen.getClassName().startsWith(refName) || methodGen.getClassName().startsWith(castName)) {
                    ++priority;
                }
                if (DEBUG) {
                    System.out.println(" priority b: " + priority);
                }
                if (castJavaClass.isInterface() && !castToAbstractCollection) {
                    ++priority;
                }
                if (DEBUG) {
                    System.out.println(" priority c: " + priority);
                }
                if (castToConcreteCollection && this.veryAbstractCollectionClasses.contains(refName)) {
                    --priority;
                }
                if (DEBUG) {
                    System.out.println(" priority d: " + priority);
                }
                if (priority <= 3 && !castToAbstractCollection && !castToConcreteCollection && (refJavaClass.isInterface() || refJavaClass.isAbstract())) {
                    ++priority;
                }
                if (DEBUG) {
                    System.out.println(" priority e: " + priority);
                }
                if (DEBUG) {
                    System.out.println(" ref name: " + refName);
                }
                if (methodGen.getName().equals("compareTo")) {
                    ++priority;
                } else if (methodGen.isPublic() && isParameter) {
                    --priority;
                }
                if (DEBUG) {
                    System.out.println(" priority h: " + priority);
                }
                if (priority < 1) {
                    priority = 1;
                }
                if (priority > 3) continue;
                String bug = "BC_UNCONFIRMED_CAST";
                if (castToConcreteCollection) {
                    bug = "BC_BAD_CAST_TO_CONCRETE_COLLECTION";
                } else if (castToAbstractCollection) {
                    bug = "BC_BAD_CAST_TO_ABSTRACT_COLLECTION";
                }
                BugInstance bugInstance = new BugInstance(this, bug, priority).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(refType, castType).addOptionalAnnotation(variable);
                accumulator.accumulateBug(bugInstance, sourceLineAnnotation);
            }
            catch (ClassNotFoundException e) {
                if (!isCast || !refSig.equals("[Ljava/lang/Object;") || !(source instanceof MethodAnnotation) || !((MethodAnnotation)source).getMethodName().equals("toArray") || !((MethodAnnotation)source).getMethodSignature().equals("()[Ljava/lang/Object;")) continue;
                this.bugReporter.reportBug(new BugInstance(this, "BC_IMPOSSIBLE_DOWNCAST_OF_TOARRAY", isCast ? 1 : 2).addClassAndMethod(methodGen, sourceFile).addFoundAndExpectedType(refType, castType).addOptionalUniqueAnnotations(variable, source).addSourceLine(sourceLineAnnotation));
            }
        }
        accumulator.reportAccumulatedBugs();
    }

    @Override
    public void report() {
    }
}

