//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.taskequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.StringEventType;
import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskEquality;
import de.ugoe.cs.autoquest.tasktrees.taskequality.SequenceComparisonRule;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISelection;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ISequence;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskFactory;
import de.ugoe.cs.autoquest.test.DummyGUIElement;

/**
 * @author Patrick Harms
 */
public class SequenceComparisonRuleTest {

    /**
     * 
     */
    @Test
    public void test() {
        ITaskFactory taskFactory = new TaskFactory();
        ITaskBuilder treeBuilder = new TaskBuilder();
        
        SequenceComparisonRule rule = new SequenceComparisonRule();
        
        IEventType eventType1 = new StringEventType("eventType1");
        IEventTarget eventTarget1 = new DummyGUIElement("elem1");

        IEventType eventType2 = new StringEventType("eventType2");
        IEventTarget eventTarget2 = new DummyGUIElement("elem2");

        ITask task1 = taskFactory.createNewEventTask(eventType1, eventTarget1);
        ITask task2 = taskFactory.createNewEventTask(eventType2, eventTarget2);
        
        assertFalse(rule.isApplicable(task1, task2));
        
        ISequence sequence1 = taskFactory.createNewSequence();
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence1));

        ISequence sequence2 = taskFactory.createNewSequence();
        
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task1);
        
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence1, sequence2));
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task1);
        
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence1, task2);
        
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence1, sequence2));
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence2, sequence1));
        
        treeBuilder.addChild(sequence2, task2);
        
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(sequence1, sequence2));
        assertEquals(TaskEquality.LEXICALLY_EQUAL, rule.compare(sequence2, sequence1));
        
        ISequence sequence3 = taskFactory.createNewSequence();
        treeBuilder.addChild(sequence3, task2);
        treeBuilder.addChild(sequence3, task1);
        
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence1, sequence3));
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence3, sequence1));
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence2, sequence3));
        assertEquals(TaskEquality.UNEQUAL, rule.compare(sequence3, sequence2));

        ISelection selection = taskFactory.createNewSelection();
        assertFalse(rule.isApplicable(sequence1, selection));
        assertFalse(rule.isApplicable(selection, sequence1));
        assertFalse(rule.isApplicable(sequence2, selection));
        assertFalse(rule.isApplicable(selection, sequence2));
        assertFalse(rule.isApplicable(sequence3, selection));
        assertFalse(rule.isApplicable(selection, sequence3));
    }

}
