//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns;

import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter.SCROLL;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter.SEQUENCE;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.EvaluationMethodCaller;
import de.ugoe.cs.autoquest.usability.result.UsabilityProblemDescriptionResolver;
import de.ugoe.cs.autoquest.usability.result.UsabilityProblemDescription;
import de.ugoe.cs.autoquest.usability.rules.UsabilityRule;
import de.ugoe.cs.autoquest.usability.rules.UsabilityUsageProblem;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class LongFormUsageProblem extends UsabilityRule implements UsabilityUsageProblem {

    private InteractionPattern longFormUsagePattern;

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     * @param taskTree
     */
    public LongFormUsageProblem(ITaskModel taskModel) {
        super(taskModel);
        this.name = "LongFormUsagePattern";
        this.defect =
            new UsabilityProblemDescriptionResolver().descriptionFor(this.getClass()
                .getSimpleName());
        initUsagePattern();
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     */
    private void initUsagePattern() {
        InteractionPattern fillFormPattern =
            InteractionPatternBuilder.newPattern().rootTask(ITERATION).startsWithEvent(TEXT_INPUT)
                .endsWithEvent(SCROLL).patternFinished().build();
        this.longFormUsagePattern =
            InteractionPatternBuilder.newPattern().rootTask(SEQUENCE).startsWithEvent(MOUSE_CLICK)
                .containsPattern(fillFormPattern).endsWithEvent(MOUSE_CLICK).patternFinished()
                .build();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.usability.rules.UsabilityRule#check()
     */
    @Override
    public Optional<UsabilityProblemDescription> check() {
        Optional<UsabilityProblemDescription> present = Optional.absent();
        if (this.longFormUsagePattern.containedIn(taskModel)) {
            present = Optional.of(this.defect);
        }
        return present;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * de.ugoe.cs.autoquest.usability.rules.UsabilityRule#callEvaluationMetho(de.ugoe.cs.autoquest
     * .usability.EvaluationMethodCaller)
     */
    @Override
    public Optional<UsabilityProblemDescription> callEvaluationMethod(EvaluationMethodCaller evaluationMethodCaller)
    {
        return evaluationMethodCaller.check(this);
    }
}
