//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.commands.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;

/**
 * <p>
 * Command that lists the content of a directory {@link GlobalDataContainer}.
 * </p>
 * 
 * @author Ralph Krimmel
 * @version 1.0
 */
public class CMDls implements Command {

	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#run(java.util.List)
	 */
	@Override
	public void run(List<Object> parameters) {

		String path;

		if (parameters.isEmpty()) {
			path = ".";
		} else {
			path = (String) parameters.get(0);
		}

		File dir = new File(path);
		if (dir.isDirectory()) {
			
			File[] filesList = dir.listFiles();
			for (File file : filesList) {
				if (file.isFile()) {
					Console.println("       " + file.getName());
				} else {
					if (file.isDirectory()) {
						Console.println("(d) " + file.getName());
					}
				}
			}
		}
	}
		
	/*
	 * (non-Javadoc)
	 * 
	 * @see de.ugoe.cs.util.console.Command#help()
	 */
	@Override
	public String help() {
		return "ls <directory>";
	}

}
