/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Obfuscate;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.SortedBugCollection;
import java.io.IOException;

public class ObfuscateBugs {
    BugCollection bugCollection;

    public ObfuscateBugs() {
    }

    public ObfuscateBugs(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public void setBugCollection(BugCollection bugCollection) {
        this.bugCollection = bugCollection;
    }

    public ObfuscateBugs execute() {
        ProjectPackagePrefixes foo = new ProjectPackagePrefixes();
        for (BugInstance b : this.bugCollection.getCollection()) {
            foo.countBug(b);
        }
        foo.report();
        return this;
    }

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        CommandLine commandLine = new CommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + ObfuscateBugs.class.getName() + " [options] [<xml results>] ");
        SortedBugCollection bugCollection = new SortedBugCollection();
        if (argCount < args.length) {
            bugCollection.readXML(args[argCount++]);
        } else {
            bugCollection.readXML(System.in);
        }
        SortedBugCollection results = bugCollection.createEmptyCollectionWithMetadata();
        Project project = results.getProject();
        project.getSourceDirList().clear();
        project.getFileList().clear();
        project.getAuxClasspathEntryList().clear();
        results.getProjectStats().getPackageStats().clear();
        results.clearMissingClasses();
        results.clearErrors();
        for (BugInstance bug : bugCollection) {
            results.add(Obfuscate.obfuscate(bug), false);
        }
        if (argCount == args.length) {
            results.writeXML(System.out);
        } else {
            results.writeXML(args[argCount++]);
        }
    }

    static class CommandLine
    extends edu.umd.cs.findbugs.config.CommandLine {
        CommandLine() {
        }

        public void handleOption(String option, String optionalExtraPart) {
            throw new IllegalArgumentException("unknown option: " + option);
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            throw new IllegalArgumentException("Unknown option : " + option);
        }
    }
}

