package de.ugoe.cs.autoquest.plugin.alignment.seqgen;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.tasktrees.manager.TaskTreeManager;
import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskEquality;
import de.ugoe.cs.autoquest.tasktrees.temporalrelation.TaskHandlingStrategy;
import de.ugoe.cs.autoquest.tasktrees.temporalrelation.TaskInstanceComparator;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskBuilder;
import de.ugoe.cs.autoquest.usageprofiles.SymbolMap;


public class SimpleSequenceGenerator implements ISequenceGenerator {

	private ArrayList<int[]> numberseqs;


	public SimpleSequenceGenerator() {
		this.numberseqs = new ArrayList<int[]>();
	
	}
	
	
	public void generate(Collection<List<Event>> sequences) {

	
		if (sequences != null) {
			TaskTreeManager ttm = new TaskTreeManager();
			ttm.createTaskModel(sequences);

			TaskHandlingStrategy preparationTaskHandlingStrategy  = new TaskHandlingStrategy(TaskEquality.SEMANTICALLY_EQUAL);
			SymbolMap<ITaskInstance, ITask> uniqueTasks = preparationTaskHandlingStrategy
					.createSymbolMap();
			TaskInstanceComparator comparator = preparationTaskHandlingStrategy
					.getTaskComparator();
			int unifiedTasks = 0;
			ITask task;
			ITaskBuilder taskBuilder = new TaskBuilder();

			List<IUserSession> sessions = ttm.getTaskModel().getUserSessions();
			for (IUserSession session : sessions) {
				//Creating a new sequence that just consists of integers
				int[] templist = new int[session.size()];
				for (int i = 0; i < session.size(); i++) {
					ITaskInstance taskInstance = session.get(i); 
					task = uniqueTasks.getValue(taskInstance);

					if (task == null) {
						uniqueTasks.addSymbol(taskInstance,
								taskInstance.getTask());
					} else {
						taskBuilder.setTask(taskInstance, task);
						unifiedTasks++;
					}
					templist[i]=task.getId();
				}

				comparator.clearBuffers();
				numberseqs.add(templist);
			}
			
		}

	}


	@Override
	public int[] get(int index) {
		return numberseqs.get(index);
	}

}
	