//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util.console;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>TextConsoleTest</code> contains tests for the class
 * <code>{@link TextConsole}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class TextConsoleTest {

	private final static String ENDLINE = System.getProperty("line.separator");
	
	private PrintStream sysOut = null;
	private PrintStream sysErr = null;

	private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
	private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();

	@Test
	public void testTextConsole_1() throws Exception {

		Console.reset();
		TextConsole result = new TextConsole();

		assertNotNull(result);
		assertTrue(Console.getInstance().hasErrorListener(result));
		assertTrue(Console.getInstance().hasExceptionListener(result));
		assertTrue(Console.getInstance().hasOutputListener(result));
		assertTrue(Console.getInstance().hasTraceListener(result));
	}

	@Test
	public void testErrorMsg_1() throws Exception {
		TextConsole fixture = new TextConsole();
		String errMessage = "test";

		fixture.errorMsg(errMessage);

		assertEquals(errMessage, errContent.toString());
	}

	@Test
	public void testLogException_1() throws Exception {
		TextConsole fixture = new TextConsole();
		Exception e = new Exception("test");
		;

		fixture.logException(e);
		assertEquals(e.getMessage() + ENDLINE, errContent.toString());
	}

	@Test
	public void testOutputMsg_1() throws Exception {
		TextConsole fixture = new TextConsole();
		String newMessage = "test";

		fixture.outputMsg(newMessage);

		assertEquals(newMessage, outContent.toString());
	}

//	@Test
//	public void testTraceMsg_1() throws Exception {
//		TextConsole fixture = new TextConsole();
//		String traceMessage = "test";
//		Level traceLevel = Level.WARNING;
//		String expectedMessage = "[WARNING] test";
//
//		fixture.traceMsg(traceMessage, traceLevel);
//
//		assertEquals(expectedMessage, outContent.toString());
//	}
//
//	@Test
//	public void testTraceMsg_2() throws Exception {
//		TextConsole fixture = new TextConsole(Level.INFO);
//		String traceMessage = "test";
//		Level traceLevel = Level.INFO;
//		String expectedMessage = "[INFO] test";
//
//		fixture.traceMsg(traceMessage, traceLevel);
//
//		assertEquals(expectedMessage, outContent.toString());
//	}
//	
//	       @Test
//	        public void testTraceMsg_3() throws Exception {
//	                TextConsole fixture = new TextConsole(Level.WARNING);
//	                String traceMessage = "[INFO] test";
//	                Level traceLevel = Level.INFO;
//	                
//
//	                fixture.traceMsg(traceMessage, traceLevel);
//
//	                assertEquals("", outContent.toString());
//	        }

	@Before
	public void setUp() throws Exception {
	    sysOut = new PrintStream(System.out);
	    sysErr = new PrintStream(System.err);
		System.setOut(new PrintStream(outContent));
		System.setErr(new PrintStream(errContent));
	}

	@After
	public void tearDown() throws Exception {
		System.setOut(sysOut);
		System.setErr(sysErr);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(TextConsoleTest.class);
	}
}