//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.operator;

import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IResult;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.UnmatchableResult;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * 
 * <p>
 * A filter that acts as a logical NOT operation on matches.
 * If the marked filter does not match, this filter will return a match (with a UNNAMEMABLE_MATCH as result).
 * If the marked filter matches, this filter will return no match found. 
 * </p>
 * 
 * @author Konni Hartmann
 */
public class Negation extends MarkingFilter {
    
    public Negation(IFilter marked) {
        super(marked);
    }
    
    public Negation(IFilter marked, IResultTransformer transformer) {
        super(marked, transformer);
    }

    @Override
    public IResult match(ITask task, IFilter filter) {
        IResult result = filter.match(task);
        if (result.isPresent())
            return UnmatchableResult.NO_MATCH_FOUND;
        else
            return UnmatchableResult.UNNAMEMABLE_MATCH_FOUND;
    }


}
