/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicVertexRenderer<V, E>
implements Renderer.Vertex<V, E> {
    @Override
    public void paintVertex(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        Graph graph = layout.getGraph();
        if (rc.getVertexIncludePredicate().evaluate(Context.getInstance(graph, v))) {
            this.paintIconForVertex(rc, v, layout);
        }
    }

    protected void paintIconForVertex(RenderContext<V, E> rc, V v, Layout<V, E> layout) {
        float y;
        GraphicsDecorator g = rc.getGraphicsContext();
        boolean vertexHit = true;
        Shape shape = rc.getVertexShapeTransformer().transform(v);
        Point2D p = (Point2D)layout.transform(v);
        p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
        float x = (float)p.getX();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y = (float)p.getY());
        shape = xform.createTransformedShape(shape);
        vertexHit = this.vertexHit(rc, shape);
        if (vertexHit) {
            if (rc.getVertexIconTransformer() != null) {
                Icon icon = rc.getVertexIconTransformer().transform(v);
                if (icon != null) {
                    g.draw(icon, rc.getScreenDevice(), shape, (int)x, (int)y);
                } else {
                    this.paintShapeForVertex(rc, v, shape);
                }
            } else {
                this.paintShapeForVertex(rc, v, shape);
            }
        }
    }

    protected boolean vertexHit(RenderContext<V, E> rc, Shape s) {
        MutableTransformer vt;
        JComponent vv = rc.getScreenDevice();
        Rectangle deviceRectangle = null;
        if (vv != null) {
            Dimension d = vv.getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        if ((vt = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW)) instanceof MutableTransformerDecorator) {
            vt = ((MutableTransformerDecorator)vt).getDelegate();
        }
        return vt.transform(s).intersects(deviceRectangle);
    }

    protected void paintShapeForVertex(RenderContext<V, E> rc, V v, Shape shape) {
        Paint drawPaint;
        GraphicsDecorator g = rc.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        Paint fillPaint = rc.getVertexFillPaintTransformer().transform(v);
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
            g.setPaint(oldPaint);
        }
        if ((drawPaint = rc.getVertexDrawPaintTransformer().transform(v)) != null) {
            g.setPaint(drawPaint);
            Stroke oldStroke = g.getStroke();
            Stroke stroke = rc.getVertexStrokeTransformer().transform(v);
            if (stroke != null) {
                g.setStroke(stroke);
            }
            g.draw(shape);
            g.setPaint(oldPaint);
            g.setStroke(oldStroke);
        }
    }
}

