//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import java.util.Map;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 16.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityDefect {

    /** */
    private UsabilityDefectSeverity severity;

    /** */
    private UsabilityDefectDescription description;

    /** */
    private Map<String, String> descriptionParameters;

    /**
     *
     */
    public UsabilityDefect(UsabilityDefectSeverity severity, UsabilityDefectDescription description)
    {
        this(severity, description, null);
    }

    /**
     *
     */
    public UsabilityDefect(UsabilityDefectSeverity    severity,
                           UsabilityDefectDescription description,
                           Map<String, String>        parameters)
    {
        this.severity = severity;
        this.description = description;
        this.descriptionParameters = parameters;
    }

    /**
     * 
     */
    public UsabilityDefectSeverity getSeverity() {
        return severity;
    }

    /**
     *
     */
    public void setSeverity(UsabilityDefectSeverity severity) {
        this.severity = severity;
    }

    /**
     *
     */
    public void setDescription(UsabilityDefectDescription description) {
        this.description = description;
    }

    /**
     * 
     */
    public String getParameterizedDescription() {
        return description.toString(descriptionParameters);
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UsabilityDefect) {
            return
                (severity == ((UsabilityDefect) obj).severity) &&
                (description == ((UsabilityDefect) obj).description);
        }
        else {
            return false;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return severity.hashCode() + description.hashCode();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "UsabilityDefect(" + severity.name() + ", " + description.name() + ")";
    }

}
