//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import org.junit.Before;

import de.ugoe.cs.autoquest.tasktrees.TaskTreeDecoder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskFactory;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstanceList;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IUserSession;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskFactory;
import de.ugoe.cs.util.console.TextConsole;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 18.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class AbstractUsabilityEvaluationTC {

    /** */
    private ITaskBuilder taskBuilder = new TaskBuilder();

    /** */
    private ITaskFactory taskFactory = new TaskFactory();

    /**
     *
     */
    @Before
    public void setUp() {
        new TextConsole(Level.FINEST);
    }

    /**
     *
     */
    protected ITaskModel createTaskModel(String spec) {
        TaskTreeDecoder decoder = new TaskTreeDecoder(taskFactory, taskBuilder);
        
        ITaskInstanceList list = decoder.decode(spec);
        
        assertTrue(list instanceof IUserSession);
        
        List<IUserSession> sessions = new ArrayList<IUserSession>();
        sessions.add((IUserSession) list);

        return taskFactory.createTaskModel(sessions);
    }

    /**
     * TODO: comment
     * 
     * @param expectedDefects
     * @param evaluateUsability
     */
    protected void assertUsabilityEvaluationResult(UsabilityDefect[]         expectedDefects,
                                                   UsabilityEvaluationResult evaluationResult)
    {
        assertEquals(evaluationResult.getAllDefects().toString(),
                     expectedDefects.length, evaluationResult.getAllDefects().size());

        EXPECTED_DEFECT_ITERATION:
        for (UsabilityDefect expectedDefect : expectedDefects) {
            for (UsabilityDefect defect : evaluationResult.getAllDefects()) {
                if (expectedDefect.equals(defect)) {
                    System.err.println(defect.getParameterizedDescription());
                    continue EXPECTED_DEFECT_ITERATION;
                }
            }

            for (UsabilityDefect defect : evaluationResult.getAllDefects()) {
                System.err.println(defect);
            }

            fail("expected defect " + expectedDefect + " not found in evaluation result");
        }
    }

}
