package de.ugoe.cs.autoquest.plugin.usability2.rules.operator.wrapper;

import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor;

public class TaskProxy extends AbstractTaskWrapper {

    /**  */
    private static final long serialVersionUID = 1L;

    ITaskWrapper reference;

    public TaskProxy() {}
    
    public void setReference(ITaskWrapper reference) {
        this.reference = reference;
    }
    
    @Override
    public ITask getReference() {
        return reference.getReference();
    }
    
    @Override
    public List<ITaskEntry> getNext() {
        return reference.getNext();
    }

    @Override
    public List<ITaskEntry> getChildren() {
        return reference.getChildren();
    }

    @Override
    public void addChild(ITaskWrapper child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChildren(List<ITaskWrapper> children) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITaskWrapper getParent() {
        return reference.getParent();
    }
    
    @Override
    public String toString() {
        return "@"+reference.toString();
    }
    
    // Implementations for ITask Interface
    
    @Override
    public int getId() {
        return reference.getId();
    }

    @Override
    public String getDescription() {
        return reference.getDescription();
    }

    @Override
    public Collection<ITaskInstance> getInstances() {
        return reference.getInstances();
    }

    @Override
    public boolean equals(ITask task) {
        return reference.equals(task);
    }

    @Override
    public void accept(ITaskVisitor visitor) {
        reference.accept(visitor);
    }
    
    @Override
    public ITask clone() {
        return super.clone();
    }
}
