/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.asm.FBClassReader;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ClassNameMismatchException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParserUsingASM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoAnalysisEngine
implements IClassAnalysisEngine<XClass> {
    @Override
    public ClassInfo analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        ClassData classData;
        if (descriptor instanceof ClassInfo) {
            return (ClassInfo)descriptor;
        }
        try {
            classData = analysisCache.getClassAnalysis(ClassData.class, descriptor);
        }
        catch (MissingClassException e) {
            if (!descriptor.getSimpleName().equals("package-info")) {
                throw e;
            }
            ClassInfo.Builder builder = new ClassInfo.Builder();
            builder.setClassDescriptor(descriptor);
            builder.setAccessFlags(1536);
            return builder.build();
        }
        FBClassReader reader = analysisCache.getClassAnalysis(FBClassReader.class, descriptor);
        ClassParserUsingASM parser = new ClassParserUsingASM(reader, descriptor, classData.getCodeBaseEntry());
        ClassInfo.Builder classInfoBuilder = new ClassInfo.Builder();
        parser.parse(classInfoBuilder);
        ClassInfo classInfo = classInfoBuilder.build();
        if (!classInfo.getClassDescriptor().equals(descriptor)) {
            throw new ClassNameMismatchException(descriptor, classInfo.getClassDescriptor(), classData.getCodeBaseEntry());
        }
        return classInfo;
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(XClass.class, this);
    }

    @Override
    public boolean canRecompute() {
        return false;
    }
}

