//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith;

import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter.MOUSE_CLICK;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.EventTypeFilter.TEXT_INPUT;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter.ITERATION;
import static de.ugoe.cs.autoquest.usability.taskmodel.filter.types.TaskTypeFilter.SEQUENCE;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPattern;
import de.ugoe.cs.autoquest.usability.rules.patterns.InteractionPatternBuilder;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskModel;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskModelUtil;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class StartsWithPatternTest {
    
    @Test
    public void starts_with_pattern_positive() {
        // Given
        String spec = "UserSession {" +
        		      "  Selection sel1 {" +
                      "    EventTask target1 {}" +
                      "  }" +
                      "  Selection sel1 {" +
                      "    Sequence seq1 {" +
                      "      Iteration iter1 {" +
                      "        Sequence seq2 {" +
                      "          TextInput target4 {}" +
                      "          MouseClick target2 {}" +
                      "          TextInput target4 {}" +
                      "        }" +
                      "      }" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        InteractionPattern startsWithPattern = InteractionPatternBuilder.newPattern().rootTask(ITERATION).startsWithEvent(TEXT_INPUT).containsEvent(MOUSE_CLICK).patternFinished().build();
        InteractionPattern pattern = InteractionPatternBuilder.newPattern().rootTask(SEQUENCE).startsWithPattern(startsWithPattern).patternFinished().build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isTrue();
    }
    
    @Test
    public void starts_with_pattern_negative() {
        // Given
        String spec = "UserSession {" +
        		      "  Sequence seq1 {" +
                      "    Selection sel1 {" +
                      "      Sequence seq2 {" +
                      "        MouseClick target4 {}" +
                      "        EventTask target2 {}" +
                      "      }" +
                      "    }" +
                      "    Selection sel1 {" +
                      "      Sequence seq3 {" +
                      "        TextInput target4 {}" +
                      "        TextInput target2 {}" +
                      "      }" +
                      "    }" +
                      "  }" +
                      "}";
        ITaskModel taskTree = GenerateTaskModelUtil.getTaskModelFromSpec(spec);
        InteractionPattern startsWithPattern = InteractionPatternBuilder.newPattern().rootTask(SEQUENCE).startsWithEvent(MOUSE_CLICK).endsWithEvent(TEXT_INPUT).patternFinished().build();
        InteractionPattern pattern = InteractionPatternBuilder.newPattern().rootTask(SEQUENCE).startsWithPattern(startsWithPattern).patternFinished().build();
        // When
        boolean patternContained = pattern.containedIn(taskTree);
        // Then
        assertThat(patternContained).isFalse();
    }

}
