//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.operator.wrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTaskInstance;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Konni Hartmann
 */
public class GenerateInstanceListVisitor extends AbstractTaskEntryInstanceVisitor {


    private List<IEventTaskInstance> _instanceList;
    
    @Override
    public void visitInstanceEntry(IEventTaskInstance value) {
        _instanceList.add(value);
    }

    public Collection<List<IEventTaskInstance>> generateInstanceList(ITask value) {
        Collection<List<IEventTaskInstance>> result = new ArrayList<List<IEventTaskInstance>>();
        
        for (ITaskInstance instance : value.getInstances()) {
            _instanceList = new ArrayList<IEventTaskInstance>();
            visitInstance(instance);
            result.add(_instanceList);
        }
        
        return result;
    }
    
}
