/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.config;

import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandLine {
    private static final String SPACES = "                    ";
    private List<String> optionList;
    private Set<String> unlistedOptions = new HashSet<String>();
    private Map<Integer, String> optionGroups;
    private Set<String> requiresArgumentSet;
    private Map<String, String> optionDescriptionMap;
    private Map<String, String> optionExtraPartSynopsisMap;
    private Map<String, String> argumentDescriptionMap;
    int maxWidth = 0;

    public CommandLine() {
        this.optionList = new LinkedList<String>();
        this.optionGroups = new HashMap<Integer, String>();
        this.requiresArgumentSet = new HashSet<String>();
        this.optionDescriptionMap = new HashMap<String, String>();
        this.optionExtraPartSynopsisMap = new HashMap<String, String>();
        this.argumentDescriptionMap = new HashMap<String, String>();
    }

    public void startOptionGroup(String description) {
        this.optionGroups.put(this.optionList.size(), description);
    }

    public void addSwitch(String option, String description) {
        this.optionList.add(option);
        this.optionDescriptionMap.put(option, description);
        if (option.length() > this.maxWidth) {
            this.maxWidth = option.length();
        }
    }

    public void addSwitchWithOptionalExtraPart(String option, String optionExtraPartSynopsis, String description) {
        this.optionList.add(option);
        this.optionExtraPartSynopsisMap.put(option, optionExtraPartSynopsis);
        this.optionDescriptionMap.put(option, description);
        int length = option.length() + optionExtraPartSynopsis.length() + 3;
        if (length > this.maxWidth) {
            this.maxWidth = length;
        }
    }

    public void addOption(String option, String argumentDesc, String description) {
        this.optionList.add(option);
        this.optionDescriptionMap.put(option, description);
        this.requiresArgumentSet.add(option);
        this.argumentDescriptionMap.put(option, argumentDesc);
        int width = option.length() + 3 + argumentDesc.length();
        if (width > this.maxWidth) {
            this.maxWidth = width;
        }
    }

    public void makeOptionUnlisted(String option) {
        this.unlistedOptions.add(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] expandOptionFiles(String[] argv, boolean ignoreComments, boolean ignoreBlankLines) throws IOException, HelpRequestedException {
        int i;
        int lastOptionIndex = this.parse(argv, true);
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> expandedOptionsList = CommandLine.getAnalysisOptionProperties(ignoreComments, ignoreBlankLines);
        for (i = 0; i < lastOptionIndex; ++i) {
            String arg = argv[i];
            if (!arg.startsWith("@")) {
                resultList.add(arg);
                continue;
            }
            BufferedReader reader = null;
            try {
                reader = UTF8.bufferedReader(new FileInputStream(arg.substring(1)));
                CommandLine.addCommandLineOptions(expandedOptionsList, reader, ignoreComments, ignoreBlankLines);
            }
            catch (Throwable throwable) {
                Util.closeSilently(reader);
                throw throwable;
            }
            Util.closeSilently(reader);
        }
        resultList.addAll(expandedOptionsList);
        for (i = lastOptionIndex; i < argv.length; ++i) {
            resultList.add(argv[i]);
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getAnalysisOptionProperties(boolean ignoreComments, boolean ignoreBlankLines) {
        ArrayList<String> resultList = new ArrayList<String>();
        URL u = DetectorFactoryCollection.getCoreResource("analysisOptions.properties");
        if (u != null) {
            BufferedReader reader = null;
            try {
                reader = UTF8.bufferedReader(u.openStream());
                CommandLine.addCommandLineOptions(resultList, reader, ignoreComments, ignoreBlankLines);
            }
            catch (IOException e) {
                AnalysisContext.logError("unable to load analysisOptions.properties", e);
            }
            finally {
                Util.closeSilently(reader);
            }
        }
        return resultList;
    }

    private static void addCommandLineOptions(ArrayList<String> resultList, BufferedReader reader, boolean ignoreComments, boolean ignoreBlankLines) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            if (ignoreComments && line.startsWith("#") || ignoreBlankLines && line.equals("")) continue;
            if (line.length() >= 2 && line.charAt(0) == '\"' && line.charAt(line.length() - 1) == '\"') {
                resultList.add(line.substring(0, line.length() - 1));
                continue;
            }
            for (String segment : line.split(" ")) {
                resultList.add(segment);
            }
        }
    }

    @SuppressWarnings(value={"DM_EXIT"})
    public int parse(String[] argv, int minArgs, int maxArgs, String usage) {
        try {
            int count = this.parse(argv);
            int remaining = argv.length - count;
            if (remaining < minArgs || remaining > maxArgs) {
                System.out.println(usage);
                System.out.println("Expected " + minArgs + "..." + maxArgs + " file arguments, found " + remaining);
                System.out.println("Options:");
                this.printUsage(System.out);
                System.exit(1);
            }
            return count;
        }
        catch (HelpRequestedException e) {
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(usage);
        System.out.println("Options:");
        this.printUsage(System.out);
        System.exit(1);
        return -1;
    }

    public int parse(String[] argv) throws IOException, HelpRequestedException {
        return this.parse(argv, false);
    }

    private int parse(String[] argv, boolean dryRun) throws IOException, HelpRequestedException {
        int arg = 0;
        while (arg < argv.length) {
            String option = argv[arg];
            if (option.equals("-help")) {
                throw new HelpRequestedException();
            }
            if (!option.startsWith("-")) break;
            String optionExtraPart = "";
            int colon = option.indexOf(58);
            if (colon >= 0) {
                optionExtraPart = option.substring(colon + 1);
                option = option.substring(0, colon);
            }
            if (this.optionDescriptionMap.get(option) == null) {
                throw new IllegalArgumentException("Unknown option: " + option);
            }
            if (this.requiresArgumentSet.contains(option)) {
                if (++arg >= argv.length) {
                    throw new IllegalArgumentException("Option " + option + " requires an argument");
                }
                String argument = argv[arg];
                if (!dryRun) {
                    this.handleOptionWithArgument(option, argument);
                }
                ++arg;
                continue;
            }
            if (!dryRun) {
                this.handleOption(option, optionExtraPart);
            }
            ++arg;
        }
        return arg;
    }

    protected abstract void handleOption(String var1, String var2) throws IOException;

    protected abstract void handleOptionWithArgument(String var1, String var2) throws IOException;

    public void printUsage(OutputStream os) {
        int count = 0;
        PrintStream out = UTF8.printStream(os);
        for (String option : this.optionList) {
            if (this.optionGroups.containsKey(count)) {
                out.println("  " + this.optionGroups.get(count));
            }
            ++count;
            if (this.unlistedOptions.contains(option)) continue;
            out.print("    ");
            StringBuilder buf = new StringBuilder();
            buf.append(option);
            if (this.optionExtraPartSynopsisMap.get(option) != null) {
                String optionExtraPartSynopsis = this.optionExtraPartSynopsisMap.get(option);
                buf.append("[:");
                buf.append(optionExtraPartSynopsis);
                buf.append("]");
            }
            if (this.requiresArgumentSet.contains(option)) {
                buf.append(" <");
                buf.append(this.argumentDescriptionMap.get(option));
                buf.append(">");
            }
            CommandLine.printField(out, buf.toString(), this.maxWidth + 1);
            out.println(this.optionDescriptionMap.get(option));
        }
        out.flush();
    }

    private static void printField(PrintStream out, String s, int width) {
        int n;
        if (s.length() > width) {
            throw new IllegalArgumentException();
        }
        out.print(s);
        for (int nSpaces = width - s.length(); nSpaces > 0; nSpaces -= n) {
            n = Math.min(SPACES.length(), nSpaces);
            out.print(SPACES.substring(0, n));
        }
    }

    public static class HelpRequestedException
    extends Exception {
    }
}

