/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BadSyntaxForRegularExpression
extends OpcodeStackDetector {
    BugReporter bugReporter;

    public BadSyntaxForRegularExpression(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private void singleDotPatternWouldBeSilly(int stackDepth, boolean ignorePasswordMasking) {
        if (ignorePasswordMasking && stackDepth != 1) {
            throw new IllegalArgumentException("Password masking requires stack depth 1, but is " + stackDepth);
        }
        if (this.stack.getStackDepth() < stackDepth) {
            return;
        }
        OpcodeStack.Item it = this.stack.getStackItem(stackDepth);
        Object value = it.getConstant();
        if (value == null || !(value instanceof String)) {
            return;
        }
        String regex = (String)value;
        if (!regex.equals(".")) {
            return;
        }
        int priority = 1;
        if (ignorePasswordMasking) {
            priority = 2;
            OpcodeStack.Item top = this.stack.getStackItem(0);
            Object topValue = top.getConstant();
            if (topValue instanceof String) {
                String replacementString = (String)topValue;
                if (replacementString.toLowerCase().equals("x") || replacementString.equals("-") || replacementString.equals("*") || replacementString.equals(" ") || replacementString.equals("\\*")) {
                    return;
                }
                if (replacementString.length() == 1 && this.getMethodName().toLowerCase().indexOf("pass") >= 0) {
                    priority = 3;
                }
            }
        }
        this.bugReporter.reportBug(new BugInstance(this, "RE_POSSIBLE_UNINTENDED_PATTERN", priority).addClassAndMethod(this).addCalledMethod(this).addSourceLine(this));
    }

    private void sawRegExPattern(int stackDepth) {
        this.sawRegExPattern(stackDepth, 0);
    }

    private void sawRegExPattern(int stackDepth, int flags) {
        if (this.stack.getStackDepth() < stackDepth) {
            return;
        }
        OpcodeStack.Item it = this.stack.getStackItem(stackDepth);
        if (it.getSpecialKind() == 10 && (flags & 0x10) == 0) {
            this.bugReporter.reportBug(new BugInstance(this, "RE_CANT_USE_FILE_SEPARATOR_AS_REGULAR_EXPRESSION", 1).addClassAndMethod(this).addCalledMethod(this).addSourceLine(this));
            return;
        }
        Object value = it.getConstant();
        if (value == null || !(value instanceof String)) {
            return;
        }
        String regex = (String)value;
        try {
            Pattern.compile(regex, flags);
        }
        catch (PatternSyntaxException e) {
            String message = e.getMessage();
            int eol = message.indexOf(10);
            if (eol > 0) {
                message = message.substring(0, eol);
            }
            BugInstance bug = new BugInstance(this, "RE_BAD_SYNTAX_FOR_REGULAR_EXPRESSION", 1).addClassAndMethod(this).addCalledMethod(this).addString(message).describe("STRING_ERROR_MSG").addString(regex).describe("STRING_REGEX");
            String options = BadSyntaxForRegularExpression.getOptions(flags);
            if (options.length() > 0) {
                bug.addString("Regex flags: " + options).describe("STRING_MESSAGE");
            }
            bug.addSourceLine(this);
            this.bugReporter.reportBug(bug);
        }
    }

    private int getIntValue(int stackDepth, int defaultValue) {
        if (this.stack.getStackDepth() < stackDepth) {
            return defaultValue;
        }
        OpcodeStack.Item it = this.stack.getStackItem(stackDepth);
        Object value = it.getConstant();
        if (value == null || !(value instanceof Integer)) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    public void sawOpcode(int seen) {
        if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("compile") && this.getSigConstantOperand().startsWith("(Ljava/lang/String;I)")) {
            this.sawRegExPattern(1, this.getIntValue(0, 0));
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("compile") && this.getSigConstantOperand().startsWith("(Ljava/lang/String;)")) {
            this.sawRegExPattern(0);
        } else if (seen == 184 && this.getClassConstantOperand().equals("java/util/regex/Pattern") && this.getNameConstantOperand().equals("matches")) {
            this.sawRegExPattern(1);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("replaceAll")) {
            this.sawRegExPattern(1);
            this.singleDotPatternWouldBeSilly(1, true);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("replaceFirst")) {
            this.sawRegExPattern(1);
            this.singleDotPatternWouldBeSilly(1, false);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("matches")) {
            this.sawRegExPattern(0);
            this.singleDotPatternWouldBeSilly(0, false);
        } else if (seen == 182 && this.getClassConstantOperand().equals("java/lang/String") && this.getNameConstantOperand().equals("split")) {
            this.sawRegExPattern(0);
            this.singleDotPatternWouldBeSilly(0, false);
        }
    }

    static void appendOption(StringBuilder b, int flags, int mask, String name) {
        if ((flags & mask) == 0) {
            return;
        }
        if (b.length() > 0) {
            b.append(" | ");
        }
        b.append("Pattern." + name);
    }

    static String getOptions(int flags) {
        StringBuilder b = new StringBuilder();
        BadSyntaxForRegularExpression.appendOption(b, flags, 128, "CANON_EQ");
        BadSyntaxForRegularExpression.appendOption(b, flags, 2, "CASE_INSENSITIVE");
        BadSyntaxForRegularExpression.appendOption(b, flags, 4, "COMMENTS");
        BadSyntaxForRegularExpression.appendOption(b, flags, 32, "DOTALL");
        BadSyntaxForRegularExpression.appendOption(b, flags, 16, "LITERAL");
        BadSyntaxForRegularExpression.appendOption(b, flags, 8, "MULTILINE");
        BadSyntaxForRegularExpression.appendOption(b, flags, 64, "UNICODE_CASE");
        BadSyntaxForRegularExpression.appendOption(b, flags, 1, "UNIX_LINES");
        return b.toString();
    }
}

