//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Base class for all mouse interaction event types.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public abstract class MouseButtonInteraction extends MouseInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * Describes the pressed mouse button.
     * </p>
     * 
     * @version 1.0
     * @author Patrick Harms
     */
    public static enum Button {
        LEFT, MIDDLE, RIGHT, X;
    }

    /**
     * <p>
     * The button used for mouse interaction
     * </p>
     */
    private Button button;

    /**
     * <p>
     * The x coordinate, where the mouse interaction took place
     * </p>
     */
    private int x;

    /**
     * <p>
     * The y coordinate, where the mouse interaction took place
     * </p>
     */
    private int y;

    /**
     * <p>
     * Constructor. Creates a new {@link MouseButtonInteraction}
     * </p>
     * 
     * @param button
     *            the button associated with the interaction
     * @param x
     *            the x coordinate of where the interaction took place on the target
     * @param y
     *            the y coordinate of where the interaction took place on the target
     */
    public MouseButtonInteraction(Button button, int x, int y) {
        this.button = button;
        this.x = x;
        this.y = y;
    }

    /**
     * <p>
     * Returns the button associated with the interaction.
     * </p>
     * 
     * @return the button
     */
    public Button getButton() {
        return button;
    }

    /**
     * <p>
     * Returns the x coordinate of where the interaction took place on the target.
     * </p>
     * 
     * @return the x coordinate
     */
    public int getX() {
        return x;
    }

    /**
     * <p>
     * Returns the y coordinate of where the interaction took place on the target.
     * </p>
     * 
     * @return the y coordinate
     */
    public int getY() {
        return y;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MouseButtonInteraction) {
            return getButton().equals(((MouseButtonInteraction) obj).getButton());
        }
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return getButton().hashCode();
    }
}
