//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.Suite.SuiteClasses;

import de.ugoe.cs.autoquest.usability.rules.metrics.NoLetterOrDigitTextInputsEvaluatorTest;
import de.ugoe.cs.autoquest.usability.rules.metrics.TextInputEntryRepetitionsEvaluatorTest;
import de.ugoe.cs.autoquest.usability.rules.metrics.TextInputRatioEvaluatorTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.LongFormUsageProblemTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.contains.ContainsAndEndsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.contains.ContainsEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.contains.ContainsPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.endswith.EndsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.endswith.EndsWithPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsAndEndsWithEventAndContainsEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsAndEndsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsAndEndsWithPatternAndContainsPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsAndEndsWithPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithEventAndContainsEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithEventAndContainsPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithEventAndEndsWithPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithEventContainsEventEndsWithPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithEventContainsPatternAndEndsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithEventContainsPatternAndEndsWithPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithPatternAndContainsEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithPatternAndContainsPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithPatternAndEndsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithPatternContainsEventAndEndsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithPatternContainsEventAndEndsWithPatternTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithPatternContainsPatternAndEndsWithEventTest;
import de.ugoe.cs.autoquest.usability.rules.patterns.visitors.startswith.StartsWithPatternTest;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
@RunWith(Suite.class)
@SuiteClasses(
    { CMDperformUsabilityEvaluationTest.class, 
      NoLetterOrDigitTextInputsEvaluatorTest.class,
      TextInputEntryRepetitionsEvaluatorTest.class, 
      TextInputRatioEvaluatorTest.class,
      StartsWithEventTest.class, StartsWithPatternTest.class,
      StartsWithEventAndContainsEventTest.class, StartsWithPatternAndContainsPatternTest.class,
      StartsWithEventAndContainsPatternTest.class, StartsWithPatternAndContainsEventTest.class, 
      StartsAndEndsWithEventTest.class, StartsAndEndsWithPatternTest.class,
      StartsWithEventAndEndsWithPatternTest.class, StartsWithPatternAndEndsWithEventTest.class,
      StartsAndEndsWithEventAndContainsEventTest.class, StartsAndEndsWithPatternAndContainsPatternTest.class,
      StartsWithEventContainsEventEndsWithPatternTest.class, StartsWithPatternContainsEventAndEndsWithPatternTest.class,
      StartsWithEventContainsPatternAndEndsWithEventTest.class, StartsWithPatternContainsPatternAndEndsWithEventTest.class,
      StartsWithEventContainsPatternAndEndsWithPatternTest.class, StartsWithPatternContainsEventAndEndsWithEventTest.class,
      EndsWithEventTest.class, EndsWithPatternTest.class,
      ContainsEventTest.class, ContainsPatternTest.class,
      ContainsAndEndsWithEventTest.class,
      // E -> P
      // P -> E
      // P -> P
      LongFormUsageProblemTest.class
    }
)
public class AllTests {

}
