//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.operator;

import java.util.LinkedList;
import java.util.List;

import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IResult;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.JoinedResult;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.UnmatchableResult;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Konni Hartmann
 */
public class Conjunction extends AbstractFilterOperator {

    public Conjunction(List<IFilter> filters) {
        super(filters);
    }

    public Conjunction(IFilter... filters) {
        super(filters);
    }
    
    @Override
    public IResult match(ITask task, List<IFilter> filters) {
        List<IResult> l = new LinkedList<IResult>();
        for (IFilter filter : filters) {
            IResult result = filter.match(task);
            if (!result.isPresent())
                return UnmatchableResult.NO_MATCH_FOUND;
            l.add(result);
        }
        return new JoinedResult(true, l);
    }

}
