//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskVisitor;

/**
 * <p>
 * this is the default implementation of the interface {@link IEventTask}. It does not do anything
 * fancy except implementing the interface.
 * </p> 
 *
 * @author Patrick Harms
 */
class EventTask extends Task implements IEventTask {
    
    /**
     * <p>
     * default serial version UID
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * simple constructor initializing this task with a description for the represented events
     * </p>
     * 
     * @param description a description for the represented events
     */
    EventTask(String description) {
        super.setDescription(description);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.Task#clone()
     */
    @Override
    public EventTask clone() {
        // Event type and target are unchangeable and do not need to be cloned
        return (EventTask) super.clone();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.Task#accept(ITaskVisitor)
     */
    @Override
    public void accept(ITaskVisitor visitor) {
        visitor.visit(this);
    }

}
