/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.jaif;

import edu.umd.cs.findbugs.jaif.JAIFSyntaxException;
import edu.umd.cs.findbugs.jaif.JAIFToken;
import edu.umd.cs.findbugs.jaif.JAIFTokenKind;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JAIFScanner {
    private static final String ID_START = "[@A-Za-z_\\$]";
    private static final String ID_REST = "[A-Za-z0-9_\\$]";
    private static final String DIGIT = "[0-9]";
    private static final String DIGITS = "[0-9]+";
    private static final String DIGITS_OPT = "[0-9]*";
    private static final String SIGN_OPT = "[+-]?";
    private static final String DOT = "\\.";
    private static final String EXP_PART = "([Ee][+-]?[0-9]+)";
    private static final String EXP_PART_OPT = "([Ee][+-]?[0-9]+)?";
    private static final String FLOAT_TYPE_SUFFIX = "[FfDd]";
    private static final String FLOAT_TYPE_SUFFIX_OPT = "[FfDd]?";
    private static final String OCTAL_DIGITS = "[0-7]+";
    private static final String HEX_SIGNIFIER = "0[Xx]";
    private static final String HEX_DIGITS = "[0-9A-Fa-f]+";
    private static final String INT_TYPE_SUFFIX_OPT = "[Ll]?";
    private static final String INPUT_CHAR = "[^\\\\\\\"]";
    private static final String OCT_ESCAPE = "([0-7]|[0-3]?[0-7][0-7])";
    private static final String ESCAPE_SEQ = "(\\\\[btnfr\"'\\\\]|\\\\([0-7]|[0-3]?[0-7][0-7]))";
    private static final String STRING_CHARS_OPT = "([^\\\\\\\"]|(\\\\[btnfr\"'\\\\]|\\\\([0-7]|[0-3]?[0-7][0-7])))*";
    private static final TokenPattern[] TOKEN_PATTERNS = new TokenPattern[]{new TokenPattern(":", JAIFTokenKind.COLON), new TokenPattern("\\(", JAIFTokenKind.LPAREN), new TokenPattern("\\)", JAIFTokenKind.RPAREN), new TokenPattern(",", JAIFTokenKind.COMMA), new TokenPattern("=", JAIFTokenKind.EQUALS), new TokenPattern("[@A-Za-z_\\$]([A-Za-z0-9_\\$])*", JAIFTokenKind.IDENTIFIER_OR_KEYWORD), new TokenPattern("[0-9]+\\.[0-9]*([Ee][+-]?[0-9]+)?[FfDd]?", JAIFTokenKind.FLOATING_POINT_LITERAL), new TokenPattern("\\.[0-9]+([Ee][+-]?[0-9]+)?[FfDd]?", JAIFTokenKind.FLOATING_POINT_LITERAL), new TokenPattern("[0-9]+([Ee][+-]?[0-9]+)[FfDd]?", JAIFTokenKind.FLOATING_POINT_LITERAL), new TokenPattern("[0-9]+([Ee][+-]?[0-9]+)?[FfDd]", JAIFTokenKind.FLOATING_POINT_LITERAL), new TokenPattern("\\.", JAIFTokenKind.DOT), new TokenPattern("0[0-7]+[Ll]?", JAIFTokenKind.OCTAL_LITERAL), new TokenPattern("0[Xx][0-9A-Fa-f]+[Ll]?", JAIFTokenKind.HEX_LITERAL), new TokenPattern("[0-9]+[Ll]?", JAIFTokenKind.DECIMAL_LITERAL), new TokenPattern("\"([^\\\\\\\"]|(\\\\[btnfr\"'\\\\]|\\\\([0-7]|[0-3]?[0-7][0-7])))*\"", JAIFTokenKind.STRING_LITERAL)};
    private BufferedReader reader;
    private JAIFToken next;
    private String lineBuf;
    private int lineNum;

    public JAIFScanner(Reader reader) {
        this.reader = new BufferedReader(reader);
        this.lineNum = 0;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    public JAIFToken nextToken() throws IOException, JAIFSyntaxException {
        if (this.next == null) {
            this.fetchToken();
        }
        JAIFToken result = this.next;
        this.next = null;
        return result;
    }

    public JAIFToken peekToken() throws IOException, JAIFSyntaxException {
        if (this.next == null) {
            this.fetchToken();
        }
        return this.next;
    }

    public boolean atEOF() throws IOException {
        this.fillLineBuf();
        return this.lineBuf == null;
    }

    private void fillLineBuf() throws IOException {
        if (this.lineBuf == null) {
            this.lineBuf = this.reader.readLine();
            if (this.lineBuf != null) {
                ++this.lineNum;
            }
        }
    }

    private boolean isHorizWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    private void fetchToken() throws IOException, JAIFSyntaxException {
        int wsCount;
        assert (this.next == null);
        this.fillLineBuf();
        if (this.lineBuf == null) {
            throw new JAIFSyntaxException(this, "Unexpected end of file");
        }
        for (wsCount = 0; wsCount < this.lineBuf.length() && this.isHorizWhitespace(this.lineBuf.charAt(wsCount)); ++wsCount) {
        }
        if (wsCount > 0) {
            this.lineBuf = this.lineBuf.substring(wsCount);
        }
        if (this.lineBuf.equals("")) {
            this.next = new JAIFToken(JAIFTokenKind.NEWLINE, "\n", this.lineNum);
            this.lineBuf = null;
            return;
        }
        for (TokenPattern tokenPattern : TOKEN_PATTERNS) {
            Matcher m = tokenPattern.getPattern().matcher(this.lineBuf);
            if (!m.find()) continue;
            String lexeme = m.group();
            this.lineBuf = this.lineBuf.substring(lexeme.length());
            this.next = new JAIFToken(tokenPattern.getKind(lexeme), lexeme, this.lineNum);
            return;
        }
        throw new JAIFSyntaxException(this, "Unrecognized token (trying to match text `" + this.lineBuf + "')");
    }

    static class TokenPattern {
        private Pattern pattern;
        private JAIFTokenKind kind;

        public TokenPattern(String regex, JAIFTokenKind kind) {
            this.pattern = Pattern.compile("^" + regex);
            this.kind = kind;
        }

        public JAIFTokenKind getKind(String lexeme) {
            return this.kind;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

