package de.ugoe.cs.autoquest.plugin.usability2.rules.operator;

import de.ugoe.cs.autoquest.plugin.usability2.rules.results.DefaultMatch;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IMatch;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.IResult;
import de.ugoe.cs.autoquest.plugin.usability2.rules.results.TransformedResult;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * 
 * <p>
 * A filter that will label the results of the marked filter with the provided name.
 * The name can later be used to retrieve a named result.
 * </p>
 * 
 * @author Konni Hartmann
 */
public class Label extends MarkingFilter {

    final String label;

    public Label(String label, IFilter marked) {
        this(label, marked, null);
    }

    public Label(String label, IFilter marked, IResultTransformer transformer) {
        super(marked, transformer);
        this.label = label;        
    }

    class LabeledTransformedResult extends TransformedResult {

        public LabeledTransformedResult(IResult result) {
            super(result);
        }

        @Override
        protected IMatch transform(IMatch next) {
            return new DefaultMatch(next.getTask(), label, next.getLabeledResults());
        }
        
    }
    
    @Override
    protected IResult match(ITask task, IFilter filter) {
        IResult result = filter.match(task);
        return new LabeledTransformedResult(result);
    }

}
