/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.AbstractField;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ComparableField;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.AnnotatedObject;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnresolvedXField
extends AbstractField {
    protected UnresolvedXField(@DottedClassName String className, String methodName, String methodSig, int accessFlags) {
        super(className, methodName, methodSig, accessFlags);
        if (methodSig.charAt(0) == '(') {
            throw new IllegalArgumentException("Bad signature: " + methodSig);
        }
        if (XFactory.DEBUG_UNRESOLVED) {
            System.out.println("Unresolved xmethod: " + this);
        }
    }

    protected UnresolvedXField(FieldDescriptor m) {
        super(m.getClassDescriptor().getDottedClassName(), m.getName(), m.getSignature(), m.isStatic() ? 8 : 0);
        if (m.getSignature().charAt(0) == '(') {
            throw new IllegalArgumentException("Bad signature: " + m.getSignature());
        }
        if (XFactory.DEBUG_UNRESOLVED) {
            System.out.println("Unresolved xmethod: " + this);
        }
    }

    @Override
    public int compareTo(ComparableField o) {
        if (o instanceof XField) {
            return XFactory.compare(this, (XField)o);
        }
        throw new ClassCastException("Don't know how to compare " + this.getClass().getName() + " to " + o.getClass().getName());
    }

    @Override
    public AnnotationValue getAnnotation(ClassDescriptor desc) {
        return null;
    }

    @Override
    public Collection<ClassDescriptor> getAnnotationDescriptors() {
        return Collections.emptyList();
    }

    @Override
    public Collection<AnnotationValue> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public AnnotatedObject getContainingScope() {
        return AnalysisContext.currentXFactory().getXClass(DescriptorFactory.createClassDescriptorFromDottedClassName(this.getClassName()));
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FIELD;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    @CheckForNull
    public String getSourceSignature() {
        return null;
    }
}

