//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.http.eventcore;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.httpmonitor.exchange.Address;
import de.ugoe.cs.autoquest.plugin.http.HTTPUtils;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTTPTarget implements IEventTarget {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private Address receiver;

    /** */
    private String stringIdentifier;

    /**
     *
     */
    public HTTPTarget(Address receiver) {
        this.receiver = receiver;
        this.stringIdentifier = HTTPUtils.toString(this.receiver);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getPlatform()
     */
    @Override
    public String getPlatform() {
        return "HTTP";
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.IEventTarget#getStringIdentifier()
     */
    @Override
    public String getStringIdentifier() {
        return stringIdentifier;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        else if (obj instanceof HTTPTarget) {
            return stringIdentifier.equals(((HTTPTarget) obj).stringIdentifier);
        }
        else {
            return false;
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return stringIdentifier.hashCode();
    }

}
