//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.http;

import de.ugoe.cs.autoquest.httpmonitor.exchange.Address;

/**
 * <p>
 * contains convenience methods used for processing HTTP exchanges
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTTPUtils {

    /**
     * <p>
     * converts an address to a simple string containing either host or ip and the port number
     * if any.
     * </p>
     * 
     * @param address the address to convert
     * 
     * @return either "host:port" or "ip:port" or "host" or "ip" or "port" or null
     */
    public static String toString(Address address) {
        if (address != null) {
            StringBuffer buffer = new StringBuffer();
            String prefix = "";
            if (address.getHost() != null) {
                buffer.append(address.getHost());
                prefix = ":";
            }
            else if (address.getIp() != null) {
                buffer.append(prefix);
                buffer.append(address.getIp());
                prefix = ":";
            }

            if (address.getPort() != null) {
                buffer.append(prefix);
                buffer.append(address.getPort());
            }

            if (buffer.length() > 0) {
                return buffer.toString();
            }
        }

        return null;
    }
    
    /**
     * <p>
     * prevent instantiation
     * </p>
     */
    private HTTPUtils() { }
    
}
