//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.temporalrelation;

import de.ugoe.cs.autoquest.tasktrees.taskequality.TaskEquality;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskInstance;
import de.ugoe.cs.autoquest.usageprofiles.DefaultSymbolMap;
import de.ugoe.cs.autoquest.usageprofiles.SymbolComparator;
import de.ugoe.cs.autoquest.usageprofiles.SymbolMap;
import de.ugoe.cs.autoquest.usageprofiles.SymbolStrategy;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class TaskHandlingStrategy implements SymbolStrategy<ITaskInstance> {
    
    /**  */
    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    private TaskEquality consideredEquality;

    /**
     * 
     */
    private TaskInstanceComparator comparator;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param consideredEquality
     */
    public TaskHandlingStrategy(TaskEquality consideredEquality) {
        this.consideredEquality = consideredEquality;
        
        if (this.consideredEquality == TaskEquality.IDENTICAL) {
            comparator = new TaskIdentityComparator();
        }
        else {
            comparator = new TaskInstanceComparator(this.consideredEquality);
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usageprofiles.SymbolStrategy#getSymbolComparator()
     */
    @Override
    public SymbolComparator<ITaskInstance> getSymbolComparator() {
        return comparator;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    public TaskInstanceComparator getTaskComparator() {
        return comparator;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usageprofiles.SymbolStrategy#createSymbolMap()
     */
    @Override
    public <V> SymbolMap<ITaskInstance, V> createSymbolMap() {
        if (consideredEquality == TaskEquality.IDENTICAL) {
            return new TaskSymbolIdentityMap<V>();
        }
        else {
            return new TaskSymbolBucketedMap<V>(comparator);
        }
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usageprofiles.SymbolStrategy#copySymbolMap(de.ugoe.cs.autoquest.usageprofiles.SymbolMap)
     */
    @Override
    public <V> SymbolMap<ITaskInstance, V> copySymbolMap(SymbolMap<ITaskInstance, V> other) {
        if (consideredEquality == TaskEquality.IDENTICAL) {
            return new DefaultSymbolMap<ITaskInstance, V>(other);
        }
        else {
            return new TaskSymbolBucketedMap<V>(comparator);
        }
    }

}
