//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

/**
 * <p>
 * This is a GUI element representing tags in HTML documents. Each tag belongs to a certain
 * document. Each page element has a tag name and either an id or at least
 * an index in the list of siblings of the same type.
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLPageElement extends HTMLGUIElement {

    /**
     * <p>
     * default serial version UID
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * instantiates a page element with it parent (either a document or another page element)
     * </p>
     *
     * @param specification the specification of the page element
     * @param parent        the parent GUI element
     */
    public HTMLPageElement(HTMLPageElementSpec specification, HTMLGUIElement parent) {
        super(specification, parent);
    }

    /**
     * <p>
     * returns the name of the tag represented by this specification
     * </p>
     *
     * @return the name of the tag represented by this specification
     */
    public String getTagName() {
        return ((HTMLPageElementSpec) super.getSpecification()).getTagName();
    }

    /**
     * <p>
     * returns the id of the tag represented by this specification
     * </p>
     *
     * @return the id of the tag represented by this specification
     */
    public String getHtmlId() {
        return ((HTMLPageElementSpec) super.getSpecification()).getHtmlId();
    }

    /**
     * <p>
     * returns the index of the tag
     * </p>
     *
     * @return the index of the tag
     */
    public int getIndex() {
        return ((HTMLPageElementSpec) super.getSpecification()).getIndex();
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.autoquest.plugin.html.guimodel.HTMLGUIElement#getElementDescriptor()
     */
    @Override
    protected String getElementDescriptor() {
        return getTagName();
    }

}
