//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeifc;

/**
 * <p>
 * the instance of an {@link IOptional}. The instance may have a child being an
 * instance of the task marked by the iteration of which this is an instance. If this instance
 * does not have a child, the optional child task was not executed.
 * </p>
 * 
 * @author Patrick Harms
 */
public interface IOptionalInstance extends ITaskInstance {

    /**
     * <p>
     * returns the child of the optional of null if the optional was not executed
     * </p>
     * 
     * @return as described
     */
    public ITaskInstance getChild();

    /**
     * <p>
     * returns the task related to the instance, i.e. the optional.
     * </p>
     * 
     * @return as described
     */
    public IOptional getOptional();

    /**
     * <p>
     * clones this task instance by creating exact clones of each contained instance
     * </p>
     * 
     * @return a clone of the task instance
     */
    public IOptionalInstance clone();

}
