//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.util;

import org.junit.*;
import static org.junit.Assert.*;

/**
 * The class <code>FileToolsTest</code> contains tests for the class
 * <code>{@link FileTools}</code>.
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public class FileToolsTest {

	final static String filenameNoCR = "testdata/de.ugoe.cs.util.FileToolsTest/testdata-nocr.txt";
	final static String filenameCR = "testdata/de.ugoe.cs.util.FileToolsTest/testdata-cr.txt";
	final static String filenameNotExists = "testdata/de.ugoe.cs.util.FileToolsTest/doesnotexist.txt";

	final static String[] expectedLines = { "line1", "line2", "line3", "",
			"line5" };

	final static String[] expectedLinesCR = { "line1\r", "line2\r", "line3\r",
			"\r", "line5" };

	final static String[] expectedWrongCR = { "line1\nline2\nline3\n\nline5" };

	@Test
	public void testGetLinesFromFile_1() throws Exception {
		String[] result = FileTools.getLinesFromFile(filenameCR, true);
		assertArrayEquals(expectedLines, result);
	}

	@Test
	public void testGetLinesFromFile_2() throws Exception {
		String[] result = FileTools.getLinesFromFile(filenameNoCR, true);
		assertArrayEquals(expectedWrongCR, result);
	}

	@Test
	public void testGetLinesFromFile_3() throws Exception {
		String[] result = FileTools.getLinesFromFile(filenameNoCR, false);
		assertArrayEquals(expectedLines, result);
	}

	@Test
	public void testGetLinesFromFile_4() throws Exception {
		String[] result = FileTools.getLinesFromFile(filenameCR, false);
		assertArrayEquals(expectedLinesCR, result);
	}

	@Test(expected = java.io.FileNotFoundException.class)
	public void testGetLinesFromFile_5() throws Exception {
		FileTools.getLinesFromFile(filenameNotExists, true);
	}

	@Test(expected = java.io.FileNotFoundException.class)
	public void testGetLinesFromFile_6() throws Exception {
		FileTools.getLinesFromFile(filenameNotExists, false);
	}

	public static void main(String[] args) {
		new org.junit.runner.JUnitCore().run(FileToolsTest.class);
	}
}