//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.usability2.rules.results;

import java.util.Iterator;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Konni Hartmann
 */
public abstract class TransformedResult implements IResult {

    final IResult result;
    
    public TransformedResult(IResult result) {
        this.result = result;
    }
    
    protected abstract IMatch transform(IMatch next);    
    
    /* (non-Javadoc)
     * @see java.lang.Iterable#iterator()
     */
    @Override
    public Iterator<IMatch> iterator() {
        return new Iterator<IMatch>() {
            Iterator<IMatch> inner = result.iterator();
            
            @Override
            public boolean hasNext() {
                return inner.hasNext();
            }

            @Override
            public IMatch next() {
                return transform(inner.next());
            }

            @Override
            public void remove() {
                inner.remove();
            }
            
        };
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.usability.rules.patterns.operator.IResult#isPresent()
     */
    @Override
    public boolean isPresent() {
        return result.isPresent();
    }

}
