//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.ui;

import static org.junit.Assert.*;
import static org.mockito.Mockito.mock;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.autoquest.commands.sequences.CMDsplitSequences;
import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.test.CommandRunner;
import de.ugoe.cs.util.console.GlobalDataContainer;
import de.ugoe.cs.util.console.TextConsole;

/**
 *
 * @author Patrick Harms
 */
public class CMDsplitSequencesTest {

    /**
     *
     */
    @Before
    public void setUp() {
        new TextConsole(Level.FINEST);
    }

    /**
     * 
     */
    @SuppressWarnings("unchecked")
    @Test
    public void test() {
        String sequencesName = "sequences";
        IEventType type = mock(IEventType.class);
        
        Collection<List<Event>> sequences = new LinkedList<List<Event>>();
        
        for (int i = 0; i < 5; i++) {
            List<Event> sequence = new LinkedList<Event>();
            
            for (int j = 0; j < 10; j++) {
                Event event = new Event(type);
                
                if (j < 3) {
                    event.setTimestamp(((i + 1) * 50) + j);
                }
                else if (j < 7) {
                    event.setTimestamp(((i + 1) * 50) + j + 15);
                }
                else {
                    event.setTimestamp(((i + 1) * 50) + j + 30);
                }
                
                sequence.add(event);
            }
            
            sequences.add(sequence);
        }
        
        GlobalDataContainer.getInstance().addData(sequencesName, sequences);
        CommandRunner.runCommand(CMDsplitSequences.class, "5", sequencesName);
        
        Object result = GlobalDataContainer.getInstance().getData(sequencesName);
        
        assertNotNull(result);
        assertTrue(result instanceof Collection<?>);
        
        sequences = (Collection<List<Event>>) result;
        
        assertEquals(15, sequences.size());
        
        for (List<Event> sequence : sequences) {
            assertNotNull(sequence);
            assertTrue((sequence.size() == 3) || (sequence.size() == 4));
        }
    }

}
