/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitor;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.autoquest.httpmonitor.proxy.HttpMonitoringProxy;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.TextConsole;
import java.util.Arrays;

public class Runner {
    public static void main(String[] args) {
        HttpMonitorComponent component;
        new TextConsole();
        String type = args.length > 0 ? args[0] : "monitor";
        String[] remainingArgs = Arrays.copyOfRange(args, 1, args.length);
        if ("monitor".equalsIgnoreCase(type)) {
            component = new HttpMonitor(remainingArgs);
        } else if ("proxy".equalsIgnoreCase(type)) {
            component = new HttpMonitoringProxy(remainingArgs);
        } else {
            throw new IllegalArgumentException("unknown type of server requested: " + type);
        }
        try {
            component.init();
        }
        catch (HttpMonitorException e) {
            Console.printerrln((String)("could not initialize HTTP " + type + " server: " + e.getMessage()));
            Console.logException((Exception)e);
        }
        try {
            component.start();
        }
        catch (HttpMonitorException e) {
            Console.printerrln((String)("could not start HTTP " + type + " server: " + e.getMessage()));
            Console.logException((Exception)e);
        }
    }
}

