/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.plugin;

import de.ugoe.cs.autoquest.plugin.AutoQUESTPlugin;
import de.ugoe.cs.autoquest.plugin.PluginLoaderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

public class PluginLoader {
    private final File pluginDir;
    private final Collection<AutoQUESTPlugin> plugins;

    public PluginLoader(File pluginDir) {
        if (pluginDir == null) {
            throw new IllegalArgumentException("Parameter pluginDir must not be null!");
        }
        if (!pluginDir.isDirectory()) {
            throw new IllegalArgumentException("File " + pluginDir.getPath() + " is not a directory");
        }
        this.pluginDir = pluginDir;
        this.plugins = new LinkedList<AutoQUESTPlugin>();
    }

    public void load() throws PluginLoaderException {
        File[] jarFiles;
        File[] fileArray = jarFiles = this.pluginDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return PluginLoader.this.checkNameConformity(name);
            }
        });
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            this.updateClassLoader(jarFile);
            String pluginName = jarFile.getName().split("-")[2];
            String pluginClassName = "de.ugoe.cs.autoquest.plugin." + pluginName + "." + pluginName.toUpperCase() + "Plugin";
            Class<?> pluginClass = null;
            try {
                pluginClass = Class.forName(pluginClassName);
            }
            catch (ClassNotFoundException e) {
                throw new PluginLoaderException("No class '" + pluginClassName + "' found in " + this.pluginDir + "/" + jarFile.getName());
            }
            try {
                AutoQUESTPlugin pluginObject = (AutoQUESTPlugin)pluginClass.newInstance();
                this.plugins.add(pluginObject);
            }
            catch (InstantiationException e) {
                throw new PluginLoaderException("Could not instantiate " + pluginClassName);
            }
            catch (IllegalAccessException e) {
                throw new PluginLoaderException("Could not access " + pluginClassName);
            }
            catch (ClassCastException e) {
                throw new PluginLoaderException("Class " + pluginClassName + " not instance of AutoQUESTPlugin");
            }
            ++n2;
        }
    }

    protected String[] getClassPathFromJar(File jarFile) {
        String[] classPath;
        ZipInputStream jarInputStream = null;
        Manifest manifest = null;
        try {
            FileInputStream fileStream = new FileInputStream(jarFile);
            try {
                jarInputStream = new JarInputStream(fileStream);
                manifest = ((JarInputStream)jarInputStream).getManifest();
            }
            finally {
                jarInputStream.close();
                fileStream.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new AssertionError((Object)"FileNotFoundException should be impossible!");
        }
        catch (IOException e) {
            throw new PluginLoaderException(e);
        }
        String jarClassPath = manifest.getMainAttributes().getValue("Class-Path");
        if (jarClassPath != null) {
            String[] jarClassPathElements = jarClassPath.split(" ");
            classPath = new String[jarClassPathElements.length];
            int i = 0;
            while (i < jarClassPathElements.length) {
                classPath[i] = "file:" + jarFile.getParentFile().getAbsolutePath() + "/" + jarClassPathElements[i];
                ++i;
            }
            try {
                jarInputStream.close();
            }
            catch (IOException e) {
                throw new PluginLoaderException(e);
            }
        } else {
            classPath = new String[]{};
        }
        return classPath;
    }

    private void updateClassLoader(File jarFile) throws PluginLoaderException {
        Method method;
        String[] classPath = this.getClassPathFromJar(jarFile);
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        }
        catch (SecurityException e) {
            throw new PluginLoaderException("addURL method of URLClassLoader not accessible via reflection.");
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"URLClassLoader does not have addURL method. Should be impossible!!");
        }
        method.setAccessible(true);
        try {
            method.invoke((Object)classLoader, new URL("file:" + jarFile.getAbsoluteFile()));
            String[] stringArray = classPath;
            int n = classPath.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                method.invoke((Object)classLoader, new URL(element));
                ++n2;
            }
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)"Illegal arguments for addURL method. Should be impossible!!");
        }
        catch (MalformedURLException e) {
            throw new PluginLoaderException(e);
        }
        catch (IllegalAccessException e) {
            throw new PluginLoaderException("addURL method of URLClassLoader not accessible via reflection.");
        }
        catch (InvocationTargetException e) {
            throw new PluginLoaderException(e);
        }
    }

    protected boolean checkNameConformity(String filename) {
        if (filename == null) {
            return false;
        }
        return filename.startsWith("autoquest-plugin-") && !filename.startsWith("autoquest-plugin-core") && (filename.split("-").length == 4 && filename.endsWith(".jar") || filename.split("-").length == 5 && filename.endsWith("SNAPSHOT.jar"));
    }

    public Collection<AutoQUESTPlugin> getPlugins() {
        return Collections.unmodifiableCollection(this.plugins);
    }
}

