/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.gui;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.gui.KeyInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.KeyPressed;
import de.ugoe.cs.autoquest.eventcore.gui.KeyReleased;
import de.ugoe.cs.autoquest.eventcore.gui.KeyTyped;
import de.ugoe.cs.autoquest.eventcore.gui.TextInput;
import de.ugoe.cs.autoquest.eventcore.guimodel.ITextArea;
import de.ugoe.cs.autoquest.eventcore.guimodel.ITextField;
import de.ugoe.cs.autoquest.keyboardmaps.KeyboardMap;
import de.ugoe.cs.autoquest.keyboardmaps.KeyboardMapFactory;
import de.ugoe.cs.autoquest.keyboardmaps.VirtualKey;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class TextInputDetector {
    private KeyboardMap keyboardMap = KeyboardMapFactory.createKeyboardMap((Locale)Locale.GERMAN);
    List<VirtualKey> pressedKeys = new ArrayList<VirtualKey>();
    private final TextInput.TextEquality textEqualityType;

    public TextInputDetector() {
        this(TextInput.TextEquality.LEXICAL);
    }

    public TextInputDetector(TextInput.TextEquality textEqualityType) {
        this.textEqualityType = textEqualityType;
    }

    public List<Event> detectTextInputs(List<Event> sequence) {
        LinkedList<Event> resultingSequence = new LinkedList<Event>();
        int textEntryStartIndex = -1;
        Object lastEventTarget = null;
        int index = 0;
        Event currentEvent = null;
        Event textInputEvent = null;
        while (index < sequence.size()) {
            currentEvent = sequence.get(index);
            textInputEvent = null;
            if (this.isKeyInteraction(currentEvent) && this.isDataInputEventTarget(currentEvent.getTarget())) {
                if (textEntryStartIndex < 0) {
                    textEntryStartIndex = index;
                    lastEventTarget = currentEvent.getTarget();
                } else if (!lastEventTarget.equals(currentEvent.getTarget())) {
                    textInputEvent = this.handleTextEntrySequence(sequence, textEntryStartIndex, index - 1, (IEventTarget)lastEventTarget);
                    textEntryStartIndex = index;
                    lastEventTarget = currentEvent.getTarget();
                }
                currentEvent = null;
            } else if (textEntryStartIndex >= 0) {
                textInputEvent = this.handleTextEntrySequence(sequence, textEntryStartIndex, index - 1, (IEventTarget)lastEventTarget);
                textEntryStartIndex = -1;
                lastEventTarget = null;
            }
            if (textInputEvent != null) {
                resultingSequence.add(textInputEvent);
            }
            if (currentEvent != null) {
                resultingSequence.add(currentEvent);
            }
            ++index;
        }
        if (textEntryStartIndex >= 0 && (textInputEvent = this.handleTextEntrySequence(sequence, textEntryStartIndex, sequence.size() - 1, (IEventTarget)lastEventTarget)) != null) {
            resultingSequence.add(textInputEvent);
        }
        return resultingSequence;
    }

    private boolean isKeyInteraction(Event event) {
        return event.getType() instanceof KeyInteraction;
    }

    private Event handleTextEntrySequence(List<Event> sequence, int startIndex, int endIndex, IEventTarget eventTarget) {
        ArrayList<Event> textInputEvents = new ArrayList<Event>();
        String enteredText = this.determineEnteredText(sequence, startIndex, endIndex, textInputEvents);
        if (enteredText != null && !"".equals(enteredText)) {
            TextInput textInput = new TextInput(enteredText, textInputEvents, this.textEqualityType);
            return new Event(textInput, eventTarget);
        }
        return null;
    }

    private boolean isDataInputEventTarget(IEventTarget eventTarget) {
        return eventTarget instanceof ITextField || eventTarget instanceof ITextArea;
    }

    private String determineEnteredText(List<Event> sequence, int startIndex, int endIndex, List<Event> textInputEvents) throws IllegalArgumentException {
        StringBuffer enteredText = new StringBuffer();
        int i = startIndex;
        while (i <= endIndex) {
            Event event = sequence.get(i);
            if (event.getType() instanceof KeyPressed || event.getType() instanceof KeyTyped) {
                VirtualKey key = ((KeyInteraction)event.getType()).getKey();
                this.pressedKeys.add(key);
                if (key == VirtualKey.BACK_SPACE) {
                    if (enteredText.length() > 0) {
                        enteredText.deleteCharAt(enteredText.length() - 1);
                    }
                } else if (key == VirtualKey.ENTER) {
                    if (!(event.getTarget() instanceof ITextField)) {
                        enteredText.append(this.getCharacter(key, this.pressedKeys));
                    }
                } else {
                    char theChar = this.getCharacter(key, this.pressedKeys);
                    if (theChar != '\u0000') {
                        enteredText.append(theChar);
                    }
                }
            } else if (event.getType() instanceof KeyReleased || event.getType() instanceof KeyTyped) {
                this.pressedKeys.remove(((KeyInteraction)event.getType()).getKey());
            } else {
                throw new IllegalArgumentException("the subsequence denoted by the indexes contains other interactions than just key strokes");
            }
            textInputEvents.add(event);
            ++i;
        }
        if (enteredText.length() > 0) {
            return enteredText.toString();
        }
        return null;
    }

    private char getCharacter(VirtualKey key, List<VirtualKey> pressedKeys) {
        boolean numlock = false;
        boolean shift = false;
        boolean altgr = false;
        for (VirtualKey pressedKey : pressedKeys) {
            if (pressedKey.isShiftKey()) {
                shift = !shift;
                continue;
            }
            if (pressedKey == VirtualKey.ALT_GRAPH) {
                altgr = !altgr;
                continue;
            }
            if (pressedKey != VirtualKey.NUM_LOCK) continue;
            boolean bl = numlock = !numlock;
        }
        return this.keyboardMap.getCharacterFor(key, numlock, shift, altgr, false);
    }
}

