/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.gui;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonDown;
import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonUp;
import de.ugoe.cs.autoquest.eventcore.gui.MouseClick;
import de.ugoe.cs.autoquest.eventcore.gui.MouseDoubleClick;
import de.ugoe.cs.autoquest.eventcore.gui.MouseDragAndDrop;
import java.util.LinkedList;
import java.util.List;

public class MouseClickCondenser {
    public List<Event> condenseMouseClicks(List<Event> sequence) {
        LinkedList<Event> resultingSequence = new LinkedList<Event>();
        int index = 0;
        while (index < sequence.size()) {
            Event click2;
            int resultingSequenceIndex;
            Event click1;
            boolean mouseClickHandled = false;
            if (index + 1 < sequence.size()) {
                Event mbDown = sequence.get(index);
                Event mbUp = sequence.get(index + 1);
                if (index + 2 < sequence.size() && this.mouseClickSequenceFound(mbDown, mbUp, sequence.get(index + 2))) {
                    resultingSequence.add(sequence.get(index += 2));
                    ++index;
                    mouseClickHandled = true;
                } else if (this.mouseClickSequenceFound(mbDown, mbUp)) {
                    index += 2;
                    resultingSequence.add(this.createClick(mbDown, mbUp));
                    mouseClickHandled = true;
                } else if (this.mouseDragAndDropSequenceFound(mbDown, mbUp)) {
                    index += 2;
                    resultingSequence.add(this.createDragAndDrop(mbDown, mbUp));
                    mouseClickHandled = true;
                } else if (this.mouseDoubleClickSequenceFound(mbDown, mbUp)) {
                    index += 2;
                    resultingSequence.add(this.createDoubleClick(mbDown, mbUp));
                    mouseClickHandled = true;
                }
            }
            if (!mouseClickHandled) {
                resultingSequence.add(sequence.get(index));
                ++index;
            }
            if (resultingSequence.size() <= 1 || !this.mouseDoubleClickSequenceFound(click1 = (Event)resultingSequence.get((resultingSequenceIndex = resultingSequence.size() - 1) - 1), click2 = (Event)resultingSequence.get(resultingSequenceIndex))) continue;
            resultingSequence.remove(resultingSequenceIndex);
            resultingSequence.remove(resultingSequenceIndex - 1);
            resultingSequence.add(this.createDoubleClick(click1, click2));
        }
        return resultingSequence;
    }

    private boolean mouseClickSequenceFound(Event mouseButtonDown, Event mouseButtonUp, Event mouseClick) {
        if (!this.mouseClickSequenceFound(mouseButtonDown, mouseButtonUp)) {
            return false;
        }
        if (!(mouseClick.getType() instanceof MouseClick)) {
            return false;
        }
        if (!this.targetsEqual(mouseButtonDown, mouseClick)) {
            return false;
        }
        if (!this.buttonsEqual(mouseButtonDown, mouseClick)) {
            return false;
        }
        return this.coordinatesEqual(mouseButtonDown, mouseClick);
    }

    private boolean mouseClickSequenceFound(Event mouseButtonDown, Event mouseButtonUp) {
        if (!(mouseButtonDown.getType() instanceof MouseButtonDown)) {
            return false;
        }
        if (!(mouseButtonUp.getType() instanceof MouseButtonUp)) {
            return false;
        }
        if (!this.targetsEqual(mouseButtonDown, mouseButtonUp)) {
            return false;
        }
        if (!this.buttonsEqual(mouseButtonDown, mouseButtonUp)) {
            return false;
        }
        return this.coordinatesEqual(mouseButtonDown, mouseButtonUp);
    }

    private boolean mouseDragAndDropSequenceFound(Event mouseButtonDown, Event mouseButtonUp) {
        if (!(mouseButtonDown.getType() instanceof MouseButtonDown)) {
            return false;
        }
        if (!(mouseButtonUp.getType() instanceof MouseButtonUp)) {
            return false;
        }
        if (!this.targetsEqual(mouseButtonDown, mouseButtonUp)) {
            return false;
        }
        MouseButtonInteraction.Button button = ((MouseButtonDown)mouseButtonDown.getType()).getButton();
        if (MouseButtonInteraction.Button.LEFT != button) {
            return false;
        }
        if (!this.buttonsEqual(mouseButtonDown, mouseButtonUp)) {
            return false;
        }
        return !this.coordinatesEqual(mouseButtonDown, mouseButtonUp);
    }

    private boolean mouseDoubleClickSequenceFound(Event click1, Event click2) {
        if (!(click1.getType() instanceof MouseClick)) {
            return false;
        }
        if (((MouseClick)click1.getType()).getButton() != MouseButtonInteraction.Button.LEFT) {
            return false;
        }
        if (!(click2.getType() instanceof MouseClick)) {
            return false;
        }
        if (!this.timestampDifferenceSmallerThan(click1, click2, 500L)) {
            return false;
        }
        if (!this.targetsEqual(click1, click2)) {
            return false;
        }
        if (!this.buttonsEqual(click1, click2)) {
            return false;
        }
        return this.coordinatesEqual(click1, click2);
    }

    private Event createClick(Event mouseButtonDown, Event mouseButtonUp) {
        MouseButtonInteraction.Button button = ((MouseButtonDown)mouseButtonDown.getType()).getButton();
        int x = ((MouseButtonDown)mouseButtonDown.getType()).getX();
        int y = ((MouseButtonDown)mouseButtonDown.getType()).getY();
        Event click = new Event(new MouseClick(button, x, y), mouseButtonDown.getTarget());
        click.setTimestamp(mouseButtonDown.getTimestamp());
        return click;
    }

    private Event createDoubleClick(Event click1, Event click2) {
        MouseButtonInteraction.Button button = ((MouseClick)click1.getType()).getButton();
        int x = ((MouseClick)click1.getType()).getX();
        int y = ((MouseClick)click1.getType()).getY();
        Event doubleClick = new Event(new MouseDoubleClick(button, x, y), click1.getTarget());
        doubleClick.setTimestamp(click1.getTimestamp());
        return doubleClick;
    }

    private Event createDragAndDrop(Event mouseButtonDown, Event mouseButtonUp) {
        int xStart = ((MouseButtonDown)mouseButtonDown.getType()).getX();
        int yStart = ((MouseButtonDown)mouseButtonDown.getType()).getY();
        int xEnd = ((MouseButtonUp)mouseButtonUp.getType()).getX();
        int yEnd = ((MouseButtonUp)mouseButtonUp.getType()).getY();
        Event dragAndDrop = new Event(new MouseDragAndDrop(xStart, yStart, xEnd, yEnd), mouseButtonDown.getTarget());
        dragAndDrop.setTimestamp(mouseButtonDown.getTimestamp());
        return dragAndDrop;
    }

    private boolean targetsEqual(Event event1, Event event2) {
        IEventTarget target1 = event1.getTarget();
        IEventTarget target2 = event2.getTarget();
        return target1 == null ? target2 == null : target1.equals(target2);
    }

    private boolean buttonsEqual(Event event1, Event event2) {
        MouseButtonInteraction.Button button2;
        MouseButtonInteraction.Button button1 = event1.getType() instanceof MouseButtonInteraction ? ((MouseButtonInteraction)event1.getType()).getButton() : null;
        MouseButtonInteraction.Button button = button2 = event2.getType() instanceof MouseButtonInteraction ? ((MouseButtonInteraction)event2.getType()).getButton() : null;
        return button1 == null ? button2 == null : button1.equals((Object)button2);
    }

    private boolean timestampDifferenceSmallerThan(Event event1, Event event2, long difference) {
        long timestamp1 = event1.getTimestamp();
        if (timestamp1 < 0L) {
            return false;
        }
        long timestamp2 = event2.getTimestamp();
        if (timestamp2 < 0L) {
            return false;
        }
        return Math.abs(timestamp2 - timestamp1) < difference;
    }

    private boolean coordinatesEqual(Event event1, Event event2) {
        int y2;
        int x2;
        int x1 = event1.getType() instanceof MouseButtonInteraction ? ((MouseButtonInteraction)event1.getType()).getX() : -1;
        int n = x2 = event2.getType() instanceof MouseButtonInteraction ? ((MouseButtonInteraction)event2.getType()).getX() : -1;
        if (x1 == -1 || x2 == -1 || x2 < x1 - 1 || x1 + 1 < x2) {
            return false;
        }
        int y1 = event1.getType() instanceof MouseButtonInteraction ? ((MouseButtonInteraction)event1.getType()).getY() : -1;
        int n2 = y2 = event2.getType() instanceof MouseButtonInteraction ? ((MouseButtonInteraction)event2.getType()).getY() : -1;
        return y1 != -1 && y2 != -1 && y1 - 1 < y2 && y2 < y1 + 1;
    }
}

