/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionPool;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class HttpDestinationOverHTTP
extends HttpDestination
implements Promise<Connection> {
    private final HttpConnectionPool connectionPool;

    public HttpDestinationOverHTTP(HttpClient client, String scheme, String host, int port) {
        super(client, scheme, host, port);
        this.connectionPool = this.newHttpConnectionPool(client);
    }

    protected HttpConnectionPool newHttpConnectionPool(HttpClient client) {
        return new HttpConnectionPool(this, client.getMaxConnectionsPerDestination(), this);
    }

    public HttpConnectionPool getHttpConnectionPool() {
        return this.connectionPool;
    }

    public void succeeded(Connection connection) {
        this.process((HttpConnectionOverHTTP)connection, true);
    }

    public void failed(final Throwable x) {
        this.getHttpClient().getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HttpDestinationOverHTTP.this.abort(x);
            }
        });
    }

    @Override
    protected void send() {
        HttpConnectionOverHTTP connection = this.acquire();
        if (connection != null) {
            this.process(connection, false);
        }
    }

    protected HttpConnectionOverHTTP acquire() {
        return (HttpConnectionOverHTTP)this.connectionPool.acquire();
    }

    protected void process(final HttpConnectionOverHTTP connection, boolean dispatch) {
        HttpClient client = this.getHttpClient();
        final HttpExchange exchange = this.getHttpExchanges().poll();
        LOG.debug("Processing exchange {} on connection {}", new Object[]{exchange, connection});
        if (exchange == null) {
            if (!this.connectionPool.release(connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                LOG.debug("{} is stopping", new Object[]{client});
                connection.close();
            }
        } else {
            Request request = exchange.getRequest();
            Throwable cause = request.getAbortCause();
            if (cause != null) {
                this.abort(exchange, cause);
                LOG.debug("Aborted before processing {}: {}", new Object[]{exchange, cause});
            } else if (dispatch) {
                client.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        connection.send(exchange);
                    }
                });
            } else {
                connection.send(exchange);
            }
        }
    }

    protected void release(HttpConnectionOverHTTP connection) {
        LOG.debug("{} released", new Object[]{connection});
        HttpClient client = this.getHttpClient();
        if (client.isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                this.process(connection, false);
            } else {
                LOG.debug("{} explicit", new Object[]{connection});
            }
        } else {
            LOG.debug("{} is stopped", new Object[]{client});
            this.remove(connection);
            connection.close();
        }
    }

    protected void remove(HttpConnectionOverHTTP connection) {
        this.connectionPool.remove(connection);
        if (!this.getHttpExchanges().isEmpty() && (connection = this.acquire()) != null) {
            this.process(connection, false);
        }
    }

    @Override
    public void close() {
        this.connectionPool.close();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this.connectionPool)});
    }
}

