/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractDefaultGUIElement
implements IGUIElement {
    public static final long serialVersionUID = 1L;
    private final IGUIElementSpec specification;
    private IGUIElement parent;
    private List<AbstractDefaultGUIElement> equalGUIElements = null;
    private boolean usageObserved;
    private GUIModel guiModel;
    private int hashCode;

    public AbstractDefaultGUIElement(IGUIElementSpec specification, IGUIElement parent) {
        this.specification = specification;
        this.usageObserved = false;
        this.setParent(parent);
        this.hashCode = specification != null ? specification.hashCode() : 0;
    }

    @Override
    public IGUIElementSpec getSpecification() {
        return this.specification;
    }

    @Override
    public IGUIElement getParent() {
        return this.parent;
    }

    @Override
    public GUIModel getGUIModel() {
        return this.guiModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEqualGUIElement(IGUIElement equalElement) {
        if (!(equalElement instanceof AbstractDefaultGUIElement)) {
            throw new IllegalArgumentException("this implementation can only handle other AbstractDefaultGUIElements");
        }
        AbstractDefaultGUIElement other = (AbstractDefaultGUIElement)equalElement;
        Class<AbstractDefaultGUIElement> clazz = AbstractDefaultGUIElement.class;
        synchronized (AbstractDefaultGUIElement.class) {
            if (this.equalGUIElements == null) {
                if (other.equalGUIElements == null) {
                    this.equalGUIElements = new LinkedList<AbstractDefaultGUIElement>();
                    this.equalGUIElements.add(this);
                    this.equalGUIElements.add(other);
                    other.equalGUIElements = this.equalGUIElements;
                    other.hashCode = this.hashCode;
                } else {
                    this.addIfNotContained(other.equalGUIElements, this);
                    this.equalGUIElements = other.equalGUIElements;
                    this.hashCode = other.hashCode;
                }
            } else if (other.equalGUIElements == null) {
                this.addIfNotContained(this.equalGUIElements, other);
                other.equalGUIElements = this.equalGUIElements;
                other.hashCode = this.hashCode;
            } else if (this.equalGUIElements != other.equalGUIElements) {
                this.equalGUIElements.addAll(other.equalGUIElements);
                for (AbstractDefaultGUIElement candidate : other.equalGUIElements) {
                    candidate.equalGUIElements = this.equalGUIElements;
                    candidate.hashCode = this.hashCode;
                }
                other.equalGUIElements = this.equalGUIElements;
                other.hashCode = this.hashCode;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isUsed() {
        return this.usageObserved;
    }

    @Override
    public void markUsed() {
        this.usageObserved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (!(other instanceof AbstractDefaultGUIElement)) return false;
        Class<AbstractDefaultGUIElement> clazz = AbstractDefaultGUIElement.class;
        synchronized (AbstractDefaultGUIElement.class) {
            IGUIElement candidate;
            if (this.equalGUIElements == null) return false;
            Iterator<AbstractDefaultGUIElement> iterator = this.equalGUIElements.iterator();
            do {
                if (iterator.hasNext()) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            } while ((candidate = (IGUIElement)iterator.next()) != other);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParent(IGUIElement newParent) {
        Class<AbstractDefaultGUIElement> clazz = AbstractDefaultGUIElement.class;
        synchronized (AbstractDefaultGUIElement.class) {
            this.parent = newParent;
            if (this.equalGUIElements != null) {
                for (AbstractDefaultGUIElement candidate : this.equalGUIElements) {
                    candidate.parent = newParent;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void setGUIModel(GUIModel guiModel) {
        this.guiModel = guiModel;
    }

    private void addIfNotContained(List<AbstractDefaultGUIElement> equalElementsList, AbstractDefaultGUIElement guiElement) {
        for (IGUIElement iGUIElement : equalElementsList) {
            if (iGUIElement != guiElement) continue;
            return;
        }
        equalElementsList.add(guiElement);
    }
}

