/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamContentProvider
implements ContentProvider {
    private static final Logger LOG = Log.getLogger(InputStreamContentProvider.class);
    private final InputStream stream;
    private final int bufferSize;

    public InputStreamContentProvider(InputStream stream) {
        this(stream, 4096);
    }

    public InputStreamContentProvider(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.bufferSize = bufferSize;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
        if (length <= 0) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return ByteBuffer.wrap(buffer, offset, length);
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new InputStreamIterator();
    }

    private class InputStreamIterator
    implements Iterator<ByteBuffer> {
        private final byte[] bytes;
        private Exception failure;
        private ByteBuffer buffer;
        private Boolean hasNext;

        private InputStreamIterator() {
            this.bytes = new byte[InputStreamContentProvider.this.bufferSize];
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.hasNext != null) {
                    return this.hasNext;
                }
                int read = InputStreamContentProvider.this.stream.read(this.bytes);
                LOG.debug("Read {} bytes from {}", new Object[]{read, InputStreamContentProvider.this.stream});
                if (read > 0) {
                    this.buffer = InputStreamContentProvider.this.onRead(this.bytes, 0, read);
                    this.hasNext = Boolean.TRUE;
                    return true;
                }
                if (read < 0) {
                    this.hasNext = Boolean.FALSE;
                    return false;
                }
                this.buffer = BufferUtil.EMPTY_BUFFER;
                this.hasNext = Boolean.TRUE;
                return true;
            }
            catch (Exception x) {
                LOG.debug((Throwable)x);
                if (this.failure == null) {
                    this.failure = x;
                    this.hasNext = Boolean.TRUE;
                    return true;
                }
                throw new IllegalStateException();
            }
        }

        @Override
        public ByteBuffer next() {
            if (this.failure != null) {
                throw (NoSuchElementException)new NoSuchElementException().initCause(this.failure);
            }
            ByteBuffer result = this.buffer;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.buffer = null;
            this.hasNext = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

