/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.keyboardmaps;

import de.ugoe.cs.autoquest.keyboardmaps.VirtualKey;
import de.ugoe.cs.util.console.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

class VirtualKeySynonyms {
    private Map<Integer, List<VirtualKey>> synonyms = new HashMap<Integer, List<VirtualKey>>();
    private Map<VirtualKey, Integer> keyIds = new HashMap<VirtualKey, Integer>();

    VirtualKeySynonyms() {
    }

    public void add(int keyId, VirtualKey virtualKey) {
        Integer existingKeyId;
        List<VirtualKey> synonymList = this.synonyms.get(keyId);
        if (synonymList == null) {
            synonymList = new ArrayList<VirtualKey>();
            this.synonyms.put(keyId, synonymList);
        }
        if (!synonymList.contains((Object)virtualKey)) {
            synonymList.add(0, virtualKey);
        }
        if ((existingKeyId = this.keyIds.get((Object)virtualKey)) != null && existingKeyId != keyId) {
            Console.traceln((Level)Level.FINEST, (String)("virtual key " + (Object)((Object)virtualKey) + " is mapped to more " + "than one key id (current is " + existingKeyId + ", new is " + keyId + "). New key id will be used (" + keyId + ")."));
        }
        this.keyIds.put(virtualKey, keyId);
    }

    public boolean containsKey(int keyId) {
        return this.synonyms.containsKey(keyId);
    }

    public VirtualKey[] getVirtualKeySynonyms(int keyId) {
        List<VirtualKey> virtualKeys = this.synonyms.get(keyId);
        if (virtualKeys != null) {
            return virtualKeys.toArray(new VirtualKey[virtualKeys.size()]);
        }
        Console.traceln((Level)Level.WARNING, (String)("no virtual key define for key id " + keyId));
        return null;
    }
}

