//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore;

import java.io.Serializable;

/**
 * <p>
 * Common interface for event types. An event type can be, e.g., a mouse click, a keyboard
 * interactions in case of GUI platforms or a HTTP request in case of a Web application.
 * </p>
 * 
 * @version 1.0
 * @author Steffen Herbold
 */
public interface IEventType extends Serializable {

    /**
     * <p>
     * Returns the name of the event type.
     * </p>
     * 
     * @return name of the event type
     */
    public String getName();

}
