//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.treeimpl;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IOptional;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITask;

/**
 * <p>
 * this is the default implementation of the interface {@link IOptional}. It does not do anything
 * fancy except implementing the interface.
 * </p> 
 *
 * @author Patrick Harms
 */
class Optional extends MarkingTemporalRelationship implements IOptional {

    /**
     * <p>
     * default serial version UID
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * simple constructor providing the base class with a human readable name of the type of this
     * task
     * </p>
     */
    Optional() {
        super("optionality");
    }
    
    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.MarkingTemporalRelationship#setMarkedTask(ITask)
     */
    @Override
    protected void setMarkedTask(ITask markedTask) {
        if (markedTask instanceof IOptional) {
            throw new IllegalArgumentException
                ("the marked task of an optional must not be an optional");
        }
        
        super.setMarkedTask(markedTask);
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.tasktrees.treeimpl.MarkingTemporalRelationship#clone()
     */
    @Override
    public Optional clone() {
        return (Optional) super.clone();
    }

}
