/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util.console;

import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.listener.IErrorListener;
import de.ugoe.cs.util.console.listener.IExceptionListener;
import de.ugoe.cs.util.console.listener.IOutputListener;
import de.ugoe.cs.util.console.listener.ITraceListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public class TextConsole
implements IOutputListener,
IErrorListener,
ITraceListener,
IExceptionListener {
    private Level traceLevel;
    private final SimpleDateFormat ft = new SimpleDateFormat("HH:mm:ss");

    public TextConsole() {
        this(Level.WARNING);
    }

    public TextConsole(Level traceLevel) {
        Console.getInstance().registerOutputListener(this);
        Console.getInstance().registerErrorListener(this);
        Console.getInstance().registerTraceListener(this);
        Console.getInstance().registerExceptionListener(this);
        this.traceLevel = traceLevel;
    }

    @Override
    public void outputMsg(String newMessage) {
        System.out.print(newMessage);
    }

    @Override
    public void errorMsg(String errMessage) {
        System.err.print(errMessage);
    }

    @Override
    public void logException(Exception e) {
        if (this.traceLevel.intValue() > Level.FINE.intValue()) {
            if (e.getMessage() != null) {
                System.err.println(e.getMessage());
            } else {
                System.err.println(e);
            }
        } else {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void traceMsg(String traceMessage, Level level) {
        if (level.intValue() >= this.traceLevel.intValue()) {
            System.out.print("[" + level.toString() + "] [" + this.ft.format(new Date()) + "] " + traceMessage);
        }
    }

    public void run() {
        CommandExecuter exec = CommandExecuter.getInstance();
        while (true) {
            System.out.print("> ");
            String command = this.getCommand().trim();
            if (command.equals("")) continue;
            exec.exec(command);
        }
    }

    protected String getCommand() {
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        try {
            bytesRead = System.in.read(buffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String command = bytesRead == 0 ? "" : new String(buffer, Charset.defaultCharset());
        return command;
    }
}

