/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util.console.defaultcommands;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.lang.WordUtils;

public class CMDman
implements Command {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(List<Object> parameters) {
        if (parameters.size() <= 0) {
            throw new IllegalArgumentException();
        }
        String command = (String)parameters.get(0);
        Command cmd = CommandExecuter.getInstance().getCMD(command);
        if (cmd != null) {
            InputStream manStream = ClassLoader.getSystemResourceAsStream("manuals/" + command);
            if (manStream != null) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(manStream, "UTF-8"));
                        String line = reader.readLine();
                        while (line != null) {
                            line = line.replace("$USAGE$", "Usage: " + cmd.help());
                            Console.println(WordUtils.wrap((String)line, (int)100));
                            line = reader.readLine();
                        }
                        return;
                    }
                    catch (IOException e) {
                        Console.printerrln("Failure reading man page");
                        Console.logException(e);
                        try {
                            if (reader == null) return;
                            reader.close();
                            return;
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            Console.println("No man page for command " + command + " available");
            return;
        }
        Console.println("Command " + command + " not found.");
    }

    @Override
    public String help() {
        return "man <commandName>";
    }
}

