/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.guimodel.AbstractDefaultGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIElementGroup;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModelException;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementFactory;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;
import de.ugoe.cs.util.console.Console;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;

public class GUIModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TreeNode root = new TreeNode();
    private Map<IGUIElement, TreeNode> allNodes = new HashMap<IGUIElement, TreeNode>();
    private boolean validate = false;

    public GUIModel() {
        this(false);
    }

    public GUIModel(boolean validate) {
        this.validate = validate;
    }

    public IGUIElement integratePath(List<? extends IGUIElementSpec> guiElementPath, IGUIElementFactory guiElementFactory) throws GUIModelException, IllegalArgumentException {
        if (guiElementPath == null || guiElementPath.size() <= 0) {
            throw new IllegalArgumentException("GUI element path must contain at least one element");
        }
        LinkedList<? extends IGUIElementSpec> remainingPath = new LinkedList<IGUIElementSpec>(guiElementPath);
        return this.integratePath(this.root, remainingPath, guiElementFactory);
    }

    public List<IGUIElement> getChildren(IGUIElement guiElement) {
        TreeNode node = this.findNode(guiElement);
        LinkedList<IGUIElement> result = null;
        if (node != null) {
            result = new LinkedList<IGUIElement>();
            if (node.children != null) {
                for (TreeNode child : node.children) {
                    result.add(child.guiElement);
                }
            }
        } else {
            System.out.println("problem");
            boolean found = false;
            for (Map.Entry<IGUIElement, TreeNode> entry : this.allNodes.entrySet()) {
                if (!entry.getKey().equals(guiElement)) continue;
                if (!found) {
                    System.out.println(String.valueOf(guiElement.hashCode()) + "  " + entry.getKey().hashCode());
                    found = true;
                    continue;
                }
                Console.traceln((Level)Level.SEVERE, (String)"Multiple nodes in the internal GUI model match the same GUI element. This should not be the case and the GUI model is probably invalid.");
            }
            if (!found) {
                Console.traceln((Level)Level.SEVERE, (String)"GUI element belonging to model not found in model");
            }
        }
        return result;
    }

    public IGUIElement getParent(IGUIElement guiElement) {
        IGUIElement parent = null;
        block0: for (Map.Entry<IGUIElement, TreeNode> entry : this.allNodes.entrySet()) {
            if (entry.getValue().children == null) continue;
            for (TreeNode child : entry.getValue().children) {
                if (!child.guiElement.equals(guiElement)) continue;
                if (parent == null) {
                    parent = entry.getKey();
                    if (this.validate) continue;
                    continue block0;
                }
                Console.traceln((Level)Level.SEVERE, (String)"Multiple nodes in the internal GUI model match the same GUI element. This should not be the case and the GUI model is probably invalid.");
            }
        }
        return parent;
    }

    public List<IGUIElement> getRootElements() {
        ArrayList<IGUIElement> roots = new ArrayList<IGUIElement>();
        if (this.root.children != null) {
            for (TreeNode rootChild : this.root.children) {
                roots.add(rootChild.guiElement);
            }
        }
        return roots;
    }

    public Traverser getTraverser() {
        return new Traverser();
    }

    public Traverser getTraverser(IGUIElement startingAt) {
        TreeNode node = this.findNode(startingAt);
        if (node != null) {
            Traverser traverser = new Traverser();
            traverser.navigateTo(node);
            return traverser;
        }
        return null;
    }

    public void dump(OutputStream out, String encoding) {
        PrintStream stream;
        if (out instanceof PrintStream) {
            stream = (PrintStream)out;
        } else {
            String enc = encoding == null ? "UTF-8" : encoding;
            try {
                stream = new PrintStream(out, true, enc);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("encodind " + enc + " not supported");
            }
        }
        for (TreeNode node : this.root.children) {
            this.dumpGUIElement(stream, node, "");
        }
    }

    public IGUIElement groupGUIElements(List<IGUIElement> guiElements, String groupName) throws IllegalArgumentException {
        if (guiElements == null || groupName == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (guiElements.size() <= 0) {
            return null;
        }
        TreeNode parent = this.findNode(guiElements.get(0).getParent());
        if (parent == null) {
            throw new IllegalArgumentException("GUI elements to group must have a parent: parent of " + guiElements.get(0) + " is " + guiElements.get(0).getParent() + " and not found " + "in the model");
        }
        LinkedList<TreeNode> nodesToGroup = new LinkedList<TreeNode>();
        for (IGUIElement element : guiElements) {
            TreeNode parentNode;
            if (!(element instanceof AbstractDefaultGUIElement)) {
                throw new IllegalArgumentException("can only group nodes of type AbstractDefaultGUIElement");
            }
            TreeNode node = this.findNode(element);
            if (node == null) {
                throw new IllegalArgumentException("GUI element " + element + " is not part of the model");
            }
            if (!nodesToGroup.contains(node)) {
                nodesToGroup.add(node);
            }
            if (parent.equals(parentNode = this.findNode(element.getParent()))) continue;
            throw new IllegalArgumentException("GUI elements do not share the same parent: " + parent + " (parent of " + guiElements.get(0) + ") <> " + parentNode + " (parent of " + element + ")");
        }
        TreeNode replacement = new TreeNode();
        replacement.guiElement = new GUIElementGroup(groupName, parent.guiElement, this);
        for (TreeNode child : nodesToGroup) {
            ((GUIElementGroup)replacement.guiElement).addToGroup(child.guiElement);
            replacement.addChildNode(child);
            ((AbstractDefaultGUIElement)child.guiElement).setParent(replacement.guiElement);
            parent.children.remove(child);
        }
        parent.children.add(replacement);
        this.allNodes.put(replacement.guiElement, replacement);
        return replacement.guiElement;
    }

    public void condenseModel() {
        this.mergeSubTree(this.root);
    }

    public IGUIElement mergeGUIElements(IGUIElement guiElement1, IGUIElement guiElement2) throws IllegalArgumentException {
        return this.mergeGUIElements(guiElement1, guiElement2, true);
    }

    public IGUIElement mergeGUIElements(IGUIElement guiElement1, IGUIElement guiElement2, boolean recursively) throws IllegalArgumentException {
        boolean sameParent;
        IGUIElement parentElement = guiElement1.getParent();
        boolean bl = parentElement != null ? parentElement.equals(guiElement2.getParent()) : (sameParent = guiElement2.getParent() == null);
        if (!sameParent) {
            throw new IllegalArgumentException("can only merge nodes with the same parent");
        }
        TreeNode parent = this.findNode(parentElement);
        if (parent == null && parentElement == null) {
            parent = this.root;
        }
        TreeNode node1 = this.findNode(guiElement1);
        TreeNode node2 = this.findNode(guiElement2);
        if (node1 == null || node2 == null) {
            throw new IllegalArgumentException("Error while merging nodes: one element is not part of the GUI model!");
        }
        TreeNode replacement = this.mergeTreeNodes(node1, node2, recursively);
        if (parent != null && parent.children != null) {
            parent.children.set(parent.children.indexOf(node1), replacement);
            parent.children.remove(node2);
        }
        return replacement.guiElement;
    }

    private IGUIElement integratePath(TreeNode parentNode, List<? extends IGUIElementSpec> remainingPath, IGUIElementFactory guiElementFactory) throws GUIModelException {
        IGUIElementSpec specToIntegrateElementFor = remainingPath.remove(0);
        TreeNode child = this.findEqualChild(parentNode, specToIntegrateElementFor);
        if (child == null) {
            IGUIElement newElement = guiElementFactory.instantiateGUIElement(specToIntegrateElementFor, parentNode.guiElement);
            if (newElement instanceof AbstractDefaultGUIElement) {
                ((AbstractDefaultGUIElement)newElement).setGUIModel(this);
            }
            child = parentNode.addChild(newElement);
            this.allNodes.put(child.guiElement, child);
        }
        if (remainingPath.size() > 0) {
            return this.integratePath(child, remainingPath, guiElementFactory);
        }
        return child.guiElement;
    }

    private TreeNode findEqualChild(TreeNode parentNode, IGUIElementSpec specToMatch) {
        if (parentNode.children != null) {
            for (TreeNode child : parentNode.children) {
                if (!specToMatch.equals(child.guiElement.getSpecification())) continue;
                return child;
            }
        }
        return null;
    }

    private void mergeSubTree(TreeNode subTreeRoot) {
        boolean performedMerge;
        if (subTreeRoot.children == null || subTreeRoot.children.isEmpty()) {
            return;
        }
        for (TreeNode child : subTreeRoot.children) {
            this.mergeSubTree(child);
        }
        do {
            performedMerge = false;
            int i = 0;
            while (!performedMerge && i < subTreeRoot.children.size()) {
                IGUIElementSpec elemSpec1 = ((TreeNode)subTreeRoot.children.get(i)).guiElement.getSpecification();
                int j = i + 1;
                while (!performedMerge && j < subTreeRoot.children.size()) {
                    IGUIElementSpec elemSpec2 = ((TreeNode)subTreeRoot.children.get(j)).guiElement.getSpecification();
                    if (elemSpec1.getSimilarity(elemSpec2)) {
                        TreeNode replacement = this.mergeTreeNodes((TreeNode)subTreeRoot.children.get(i), (TreeNode)subTreeRoot.children.get(j), true);
                        subTreeRoot.children.set(i, replacement);
                        subTreeRoot.children.remove(j);
                        performedMerge = true;
                        --i;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } while (performedMerge);
    }

    private TreeNode mergeTreeNodes(TreeNode treeNode1, TreeNode treeNode2, boolean recursively) {
        TreeNode replacement = new TreeNode();
        replacement.guiElement = treeNode1.guiElement;
        if (treeNode1.children != null) {
            for (TreeNode child : treeNode1.children) {
                replacement.addChildNode(child);
            }
        }
        if (treeNode2.children != null) {
            for (TreeNode child : treeNode2.children) {
                replacement.addChildNode(child);
            }
        }
        if (recursively) {
            this.mergeSubTree(replacement);
        }
        replacement.guiElement.updateSpecification(treeNode2.guiElement.getSpecification());
        this.allNodes.remove(treeNode1.guiElement);
        this.allNodes.remove(treeNode2.guiElement);
        treeNode1.guiElement.addEqualGUIElement(treeNode2.guiElement);
        treeNode2.guiElement.addEqualGUIElement(treeNode1.guiElement);
        this.allNodes.put(replacement.guiElement, replacement);
        return replacement;
    }

    private void dumpGUIElement(PrintStream out, TreeNode node, String indent) {
        out.print(indent);
        out.print(node.guiElement);
        if (node.children != null && node.children.size() > 0) {
            out.println(" {");
            for (TreeNode child : node.children) {
                this.dumpGUIElement(out, child, String.valueOf(indent) + "  ");
            }
            out.print(indent);
            out.print("}");
        }
        out.println();
    }

    private TreeNode findNode(IGUIElement element) {
        if (element == null) {
            return null;
        }
        TreeNode result = null;
        if (!this.validate) {
            result = this.allNodes.get(element);
        } else {
            for (Map.Entry<IGUIElement, TreeNode> entry : this.allNodes.entrySet()) {
                if (!entry.getKey().equals(element)) continue;
                if (result == null) {
                    result = entry.getValue();
                    continue;
                }
                Console.traceln((Level)Level.SEVERE, (String)"Multiple nodes in the internal GUI model match the same GUI element. This should not be the case and the GUI model is probably invalid.");
            }
        }
        return result;
    }

    public class Traverser {
        private Stack<StackEntry> nodeStack = new Stack();

        private Traverser() {
            this.nodeStack.push(new StackEntry(GUIModel.this.root, 0));
        }

        public IGUIElement firstChild() {
            return this.pushChild(0);
        }

        public boolean hasFirstChild() {
            return this.nodeStack.peek().treeNode.children != null && this.nodeStack.peek().treeNode.children.size() > 0;
        }

        public IGUIElement nextSibling() {
            int lastIndex = this.nodeStack.pop().index;
            IGUIElement retval = this.pushChild(lastIndex + 1);
            if (retval == null) {
                this.pushChild(lastIndex);
            }
            return retval;
        }

        public boolean hasNextSibling() {
            boolean result = false;
            if (this.nodeStack.size() > 1) {
                StackEntry entry = this.nodeStack.pop();
                result = this.nodeStack.peek().treeNode.children.size() > entry.index + 1;
                this.pushChild(entry.index);
            }
            return result;
        }

        public IGUIElement parent() {
            IGUIElement retval = null;
            if (this.nodeStack.size() > 1) {
                this.nodeStack.pop();
                retval = this.nodeStack.peek().treeNode.guiElement;
            }
            return retval;
        }

        private IGUIElement pushChild(int index) {
            IGUIElement retVal = null;
            if (this.nodeStack.peek().treeNode.children != null && this.nodeStack.peek().treeNode.children.size() > index) {
                this.nodeStack.push(new StackEntry((TreeNode)this.nodeStack.peek().treeNode.children.get(index), index));
                retVal = this.nodeStack.peek().treeNode.guiElement;
            }
            return retVal;
        }

        private boolean navigateTo(TreeNode node) {
            if (this.hasFirstChild()) {
                IGUIElement childElement = this.firstChild();
                while (childElement != null) {
                    if (childElement.equals(node.guiElement)) {
                        return true;
                    }
                    if (this.navigateTo(node)) {
                        return true;
                    }
                    childElement = this.nextSibling();
                }
                this.parent();
            }
            return false;
        }

        private class StackEntry {
            private TreeNode treeNode;
            private int index;

            private StackEntry(TreeNode treeNode, int index) {
                this.treeNode = treeNode;
                this.index = index;
            }
        }
    }

    private static class TreeNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private IGUIElement guiElement;
        private List<TreeNode> children;

        private TreeNode() {
        }

        private TreeNode addChild(IGUIElement guiElement) {
            if (this.children == null) {
                this.children = new ArrayList<TreeNode>();
            }
            TreeNode child = new TreeNode();
            child.guiElement = guiElement;
            this.children.add(child);
            return child;
        }

        private TreeNode addChildNode(TreeNode node) {
            if (this.children == null) {
                this.children = new ArrayList<TreeNode>();
            }
            this.children.add(node);
            return node;
        }

        public String toString() {
            return this.guiElement.toString();
        }
    }
}

