/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.autoquest.httpmonitor;

import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorComponent;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorException;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorLogManager;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorServer;
import de.ugoe.cs.autoquest.httpmonitor.HttpMonitorServlet;
import de.ugoe.cs.autoquest.httpmonitor.ShutdownHook;
import de.ugoe.cs.util.console.Console;
import javax.servlet.Servlet;

public class HttpMonitor
implements HttpMonitorComponent {
    private int port = 8090;
    private HttpMonitorServer server;
    private String logFileBaseDir;
    private HttpMonitorLogManager logManager;
    private Thread shutdownHook;

    public HttpMonitor(String[] commandLineArguments) {
        if (commandLineArguments.length > 0) {
            this.logFileBaseDir = commandLineArguments[0];
            Console.println("putting logs into directory " + this.logFileBaseDir);
        }
        if (commandLineArguments.length > 1) {
            try {
                this.port = Integer.parseInt(commandLineArguments[1]);
            }
            catch (NumberFormatException e) {
                Console.println("ignoring invalid port specification " + commandLineArguments[1]);
            }
            Console.println("listening on port " + this.port);
        }
    }

    @Override
    public synchronized void init() throws HttpMonitorException {
        if (this.server != null) {
            throw new IllegalStateException("already initialized.");
        }
        try {
            this.logManager = new HttpMonitorLogManager(this.logFileBaseDir);
            this.logManager.init();
            HttpMonitorServlet servlet = new HttpMonitorServlet(this.logManager);
            this.server = new HttpMonitorServer(this.port, (Servlet)servlet);
            this.server.init();
            this.shutdownHook = new Thread(new ShutdownHook(this.server, this.logManager));
        }
        catch (HttpMonitorException e) {
            Console.printerrln("could not initialize HTTP monitor: " + e);
            Console.logException(e);
        }
    }

    @Override
    public synchronized void start() {
        if (this.server == null) {
            throw new IllegalStateException("not initialized.");
        }
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.logManager.start();
            this.server.start();
        }
        catch (HttpMonitorException e) {
            Console.printerrln("could not start HTTP monitor: " + e);
            Console.logException(e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.server == null) {
            throw new IllegalStateException("not initialized.");
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.server.stop();
        this.logManager.stop();
        this.server = null;
        this.logManager = null;
    }
}

