/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.TimeoutCompleteListener;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.PathContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Fields;

public class HttpRequest
implements Request {
    private static final AtomicLong ids = new AtomicLong();
    private final HttpFields headers = new HttpFields();
    private final Fields params = new Fields();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final List<Request.RequestListener> requestListeners = new ArrayList<Request.RequestListener>();
    private final List<Response.ResponseListener> responseListeners = new ArrayList<Response.ResponseListener>();
    private final HttpClient client;
    private final long conversation;
    private final String host;
    private final int port;
    private URI uri;
    private String scheme;
    private String path;
    private String query;
    private String method = HttpMethod.GET.asString();
    private HttpVersion version = HttpVersion.HTTP_1_1;
    private long idleTimeout;
    private long timeout;
    private ContentProvider content;
    private boolean followRedirects;
    private volatile Throwable aborted;

    public HttpRequest(HttpClient client, URI uri) {
        this(client, ids.incrementAndGet(), uri);
    }

    protected HttpRequest(HttpClient client, long conversation, URI uri) {
        this.client = client;
        this.conversation = conversation;
        this.scheme = uri.getScheme();
        this.host = client.normalizeHost(uri.getHost());
        this.port = client.normalizePort(this.scheme, uri.getPort());
        this.path = uri.getRawPath();
        this.query = uri.getRawQuery();
        this.extractParams(this.query);
        this.followRedirects(client.isFollowRedirects());
        this.idleTimeout = client.getIdleTimeout();
        HttpField acceptEncodingField = client.getAcceptEncodingField();
        if (acceptEncodingField != null) {
            this.headers.put(acceptEncodingField);
        }
        this.headers.put(client.getUserAgentField());
    }

    @Override
    public long getConversationID() {
        return this.conversation;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public Request scheme(String scheme) {
        this.scheme = scheme;
        this.uri = null;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Request method(HttpMethod method) {
        return this.method(method.asString());
    }

    @Override
    public Request method(String method) {
        this.method = Objects.requireNonNull(method).toUpperCase(Locale.ENGLISH);
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Request path(String path) {
        URI uri = URI.create(path);
        String rawPath = uri.getRawPath();
        if (uri.isOpaque()) {
            rawPath = path;
        }
        if (rawPath == null) {
            rawPath = "";
        }
        this.path = rawPath;
        String query = uri.getRawQuery();
        if (query != null) {
            this.query = query;
            this.params.clear();
            this.extractParams(query);
        }
        if (uri.isAbsolute()) {
            this.path = this.buildURI(false).toString();
        }
        this.uri = null;
        return this;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public URI getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        this.uri = this.buildURI(true);
        return this.uri;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    @Override
    public Request version(HttpVersion version) {
        this.version = Objects.requireNonNull(version);
        return this;
    }

    @Override
    public Request param(String name, String value) {
        this.params.add(name, value);
        this.query = this.buildQuery();
        this.uri = null;
        return this;
    }

    @Override
    public Fields getParams() {
        return new Fields(this.params, true);
    }

    @Override
    public String getAgent() {
        return this.headers.get(HttpHeader.USER_AGENT);
    }

    @Override
    public Request agent(String agent) {
        this.headers.put(HttpHeader.USER_AGENT, agent);
        return this;
    }

    @Override
    public Request header(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            this.headers.add(name, value);
        }
        return this;
    }

    @Override
    public Request header(HttpHeader header, String value) {
        if (value == null) {
            this.headers.remove(header);
        } else {
            this.headers.add(header, value);
        }
        return this;
    }

    @Override
    public Request attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public HttpFields getHeaders() {
        return this.headers;
    }

    @Override
    public <T extends Request.RequestListener> List<T> getRequestListeners(Class<T> type) {
        if (type == null) {
            return this.requestListeners;
        }
        ArrayList<Request.RequestListener> result = new ArrayList<Request.RequestListener>();
        for (Request.RequestListener listener : this.requestListeners) {
            if (!type.isInstance(listener)) continue;
            result.add(listener);
        }
        return result;
    }

    @Override
    public Request listener(Request.Listener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestQueued(Request.QueuedListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestBegin(Request.BeginListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestHeaders(Request.HeadersListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestCommit(Request.CommitListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestContent(Request.ContentListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestSuccess(Request.SuccessListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onRequestFailure(Request.FailureListener listener) {
        this.requestListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseBegin(Response.BeginListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseHeader(Response.HeaderListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseHeaders(Response.HeadersListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseContent(Response.ContentListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseSuccess(Response.SuccessListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public Request onResponseFailure(Response.FailureListener listener) {
        this.responseListeners.add(listener);
        return this;
    }

    @Override
    public ContentProvider getContent() {
        return this.content;
    }

    @Override
    public Request content(ContentProvider content) {
        return this.content(content, null);
    }

    @Override
    public Request content(ContentProvider content, String contentType) {
        if (contentType != null) {
            this.header(HttpHeader.CONTENT_TYPE, contentType);
        }
        this.content = content;
        return this;
    }

    @Override
    public Request file(Path file) throws IOException {
        return this.file(file, "application/octet-stream");
    }

    @Override
    public Request file(Path file, String contentType) throws IOException {
        if (contentType != null) {
            this.header(HttpHeader.CONTENT_TYPE, contentType);
        }
        return this.content(new PathContentProvider(file));
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public Request followRedirects(boolean follow) {
        this.followRedirects = follow;
        return this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Request idleTimeout(long timeout, TimeUnit unit) {
        this.idleTimeout = unit.toMillis(timeout);
        return this;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Request timeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
        return this;
    }

    @Override
    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        FutureResponseListener listener = new FutureResponseListener(this);
        this.send(this, listener);
        try {
            long timeout = this.getTimeout();
            if (timeout <= 0L) {
                return listener.get();
            }
            return listener.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException x) {
            this.abort(x);
            throw x;
        }
    }

    @Override
    public void send(Response.CompleteListener listener) {
        if (this.getTimeout() > 0L) {
            TimeoutCompleteListener timeoutListener = new TimeoutCompleteListener(this);
            timeoutListener.schedule(this.client.getScheduler());
            this.responseListeners.add(timeoutListener);
        }
        this.send(this, listener);
    }

    private void send(Request request, Response.CompleteListener listener) {
        if (listener != null) {
            this.responseListeners.add(listener);
        }
        this.client.send(request, this.responseListeners);
    }

    @Override
    public boolean abort(Throwable cause) {
        this.aborted = Objects.requireNonNull(cause);
        HttpConversation conversation = this.client.getConversation(this.getConversationID(), false);
        return conversation != null && conversation.abort(cause);
    }

    @Override
    public Throwable getAbortCause() {
        return this.aborted;
    }

    private String buildQuery() {
        StringBuilder result = new StringBuilder();
        Iterator iterator = this.params.iterator();
        while (iterator.hasNext()) {
            Fields.Field field = (Fields.Field)iterator.next();
            String[] values = field.values();
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    result.append("&");
                }
                result.append(field.name()).append("=");
                result.append(this.urlEncode(values[i]));
            }
            if (!iterator.hasNext()) continue;
            result.append("&");
        }
        return result.toString();
    }

    private String urlEncode(String value) {
        String encoding = "UTF-8";
        try {
            return URLEncoder.encode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(encoding);
        }
    }

    private void extractParams(String query) {
        if (query != null) {
            for (String nameValue : query.split("&")) {
                String name;
                String[] parts = nameValue.split("=");
                if (parts.length <= 0 || (name = parts[0]).trim().length() == 0) continue;
                this.param(name, parts.length < 2 ? "" : this.urlDecode(parts[1]));
            }
        }
    }

    private String urlDecode(String value) {
        String charset = "UTF-8";
        try {
            return URLDecoder.decode(value, charset);
        }
        catch (UnsupportedEncodingException x) {
            throw new UnsupportedCharsetException(charset);
        }
    }

    private URI buildURI(boolean withQuery) {
        URI result;
        String path = this.getPath();
        String query = this.getQuery();
        if (query != null && withQuery) {
            path = path + "?" + query;
        }
        if (!(result = URI.create(path)).isAbsolute() && !result.isOpaque()) {
            result = URI.create(this.client.address(this.getScheme(), this.getHost(), this.getPort()) + path);
        }
        return result;
    }

    public String toString() {
        return String.format("%s[%s %s %s]@%x", HttpRequest.class.getSimpleName(), this.getMethod(), this.getPath(), this.getVersion(), this.hashCode());
    }
}

